/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.set;

import org.psjava.ds.map.MutableMap;
import org.psjava.ds.set.DisjointSet;
import org.psjava.goods.GoodMutableMapFactory;

public class DisjointSetForest<T>
implements DisjointSet<T> {
    final MutableMap<T, NodeInfo<T>> nodeInfo = GoodMutableMapFactory.getInstance().create();

    @Override
    public void makeSet(T value) {
        this.nodeInfo.add(value, new NodeInfo<T>(value, 0));
    }

    @Override
    public void union(T x, T y) {
        T yrep;
        T xrep = this.find(x);
        if (xrep == (yrep = this.find(y))) {
            return;
        }
        NodeInfo xinfo = (NodeInfo)this.nodeInfo.get(xrep);
        NodeInfo yinfo = (NodeInfo)this.nodeInfo.get(yrep);
        if (xinfo.rank > yinfo.rank) {
            yinfo.parent = xrep;
        } else {
            xinfo.parent = yrep;
            if (xinfo.rank == yinfo.rank) {
                ++yinfo.rank;
            }
        }
    }

    @Override
    public T find(T x) {
        NodeInfo info = (NodeInfo)this.nodeInfo.get(x);
        if (!info.parent.equals(x)) {
            info.parent = this.find(info.parent);
        }
        return info.parent;
    }

    private static class NodeInfo<T> {
        T parent;
        int rank;

        NodeInfo(T p, int rank) {
            this.parent = p;
            this.rank = rank;
        }
    }
}

