/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.Map;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetDriver;
import org.monetdb.jdbc.MonetWrapper;

final class MonetParameterMetaData
extends MonetWrapper
implements ParameterMetaData {
    private final MonetConnection conn;
    private final int paramCount;
    private final String[] monetdbTypes;
    private final int[] JdbcSQLTypes;
    private final int[] precisions;
    private final int[] scales;

    MonetParameterMetaData(MonetConnection monetConnection, int n, String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3) throws IllegalArgumentException {
        if (monetConnection == null) {
            throw new IllegalArgumentException("Connection may not be null!");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("MonetDB Types may not be null!");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("JDBC Types may not be null!");
        }
        if (nArray2 == null) {
            throw new IllegalArgumentException("Precisions may not be null!");
        }
        if (nArray3 == null) {
            throw new IllegalArgumentException("Scales may not be null!");
        }
        if (stringArray.length != nArray2.length || stringArray.length != n + 1) {
            throw new IllegalArgumentException("Inconsistent Parameters metadata");
        }
        this.conn = monetConnection;
        this.paramCount = n;
        this.monetdbTypes = stringArray;
        this.JdbcSQLTypes = nArray;
        this.precisions = nArray2;
        this.scales = nArray3;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkParameterIndexValidity(n);
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        switch (this.getParameterType(n)) {
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 93: 
            case 2014: {
                return true;
            }
            case -5: {
                String string = this.getParameterTypeName(n);
                return !"oid".equals(string) && !"ptr".equals(string);
            }
        }
        return false;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        switch (this.getParameterType(n)) {
            case -5: {
                return 19;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case -6: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 6: 
            case 8: {
                return 15;
            }
            case 2: 
            case 3: {
                try {
                    String string = this.monetdbTypes[n];
                    if (string != null && string.endsWith("_interval")) {
                        switch (this.precisions[n]) {
                            case 1: {
                                return 4;
                            }
                            case 2: {
                                return 6;
                            }
                            case 3: {
                                return 6;
                            }
                            case 4: {
                                return 9;
                            }
                            case 5: {
                                return 11;
                            }
                            case 6: {
                                return 13;
                            }
                            case 7: {
                                return 15;
                            }
                            case 8: {
                                return 11;
                            }
                            case 9: {
                                return 13;
                            }
                            case 10: {
                                return 15;
                            }
                            case 11: {
                                return 13;
                            }
                            case 12: {
                                return 15;
                            }
                            case 13: {
                                return 15;
                            }
                        }
                        if ("sec_interval".equals(string)) {
                            return 15;
                        }
                        if ("day_interval".equals(string)) {
                            return 9;
                        }
                        if ("month_interval".equals(string)) {
                            return 6;
                        }
                    }
                    return this.precisions[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw this.newSQLInvalidParameterIndexException(n);
                }
            }
            case 1: 
            case 12: 
            case 2005: {
                try {
                    return this.precisions[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw this.newSQLInvalidParameterIndexException(n);
                }
            }
            case -3: 
            case -2: 
            case 2004: {
                try {
                    return this.precisions[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw this.newSQLInvalidParameterIndexException(n);
                }
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 15;
            }
            case 2013: {
                return 21;
            }
            case 93: {
                return 26;
            }
            case 2014: {
                return 32;
            }
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkParameterIndexValidity(n);
        try {
            return this.scales[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.newSQLInvalidParameterIndexException(n);
        }
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkParameterIndexValidity(n);
        try {
            return this.JdbcSQLTypes[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.newSQLInvalidParameterIndexException(n);
        }
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkParameterIndexValidity(n);
        try {
            String string = this.monetdbTypes[n];
            if (string != null && string.endsWith("_interval")) {
                switch (this.precisions[n]) {
                    case 1: {
                        return "interval year";
                    }
                    case 2: {
                        return "interval year to month";
                    }
                    case 3: {
                        return "interval month";
                    }
                    case 4: {
                        return "interval day";
                    }
                    case 5: {
                        return "interval day to hour";
                    }
                    case 6: {
                        return "interval day to minute";
                    }
                    case 7: {
                        return "interval day to second";
                    }
                    case 8: {
                        return "interval hour";
                    }
                    case 9: {
                        return "interval hour to minute";
                    }
                    case 10: {
                        return "interval hour to second";
                    }
                    case 11: {
                        return "interval minute";
                    }
                    case 12: {
                        return "interval minute to second";
                    }
                    case 13: {
                        return "interval second";
                    }
                }
                if ("day_interval".equals(string)) {
                    return "interval day";
                }
                if ("month_interval".equals(string)) {
                    return "interval month";
                }
                if ("sec_interval".equals(string)) {
                    return "interval second";
                }
            }
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw this.newSQLInvalidParameterIndexException(n);
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        String string = this.getParameterTypeName(n);
        Map<String, Class<?>> map = this.conn.getTypeMap();
        Class<?> clazz = map != null && map.containsKey(string) ? map.get(string) : MonetDriver.getClassForType(this.getParameterType(n));
        if (clazz != null) {
            return clazz.getCanonicalName();
        }
        throw new SQLException("parameter type mapping null: " + string, "M0M03");
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkParameterIndexValidity(n);
        return 1;
    }

    private final void checkParameterIndexValidity(int n) throws SQLDataException {
        if (n < 1 || n > this.paramCount) {
            throw this.newSQLInvalidParameterIndexException(n);
        }
    }

    private final SQLDataException newSQLInvalidParameterIndexException(int n) {
        return new SQLDataException("Invalid Parameter Index number: " + n, "22010");
    }
}

