/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.net.URISyntaxException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.monetdb.mcl.net.MonetUrlParser;
import org.monetdb.mcl.net.Parameter;
import org.monetdb.mcl.net.ParameterType;
import org.monetdb.mcl.net.ValidationError;

public final class Target {
    protected static final Target defaults = new Target();
    private static final Pattern namePattern = Pattern.compile("^[a-zzA-Z_][-a-zA-Z0-9_.]*$");
    private static final Pattern hashPattern = Pattern.compile("^sha256:[0-9a-fA-F:]*$");
    private boolean tls = false;
    private String host = "";
    private int port = -1;
    private String database = "";
    private String tableschema = "";
    private String table = "";
    private String sock = "";
    private String sockdir = "/tmp";
    private String cert = "";
    private String certhash = "";
    private String clientkey = "";
    private String clientcert = "";
    private String user = "";
    private String password = "";
    private String language = "sql";
    private boolean autocommit = true;
    private String schema = "";
    private int timezone = (Integer)Parameter.TIMEZONE.getDefault();
    private String binary = "on";
    private int replySize = 250;
    private String hash = "";
    private boolean debug = false;
    private String logfile = "";
    private int soTimeout = 0;
    private boolean treatClobAsVarchar = true;
    private boolean treatBlobAsBinary = true;
    private boolean clientInfo = true;
    private String clientApplication = "";
    private String clientRemark = "";
    private boolean userWasSet = false;
    private boolean passwordWasSet = false;
    private Validated validated = null;

    public Target() {
    }

    public Target(String string, Properties properties) throws URISyntaxException, ValidationError {
        this();
        this.setProperties(properties);
        this.parseUrl(string);
    }

    public static String packHost(String string) {
        switch (string) {
            case "localhost": {
                return "localhost.";
            }
            case "": {
                return "localhost";
            }
        }
        return string;
    }

    public static String unpackHost(String string) {
        switch (string) {
            case "localhost.": {
                return "localhost";
            }
            case "localhost": {
                return "";
            }
        }
        return string;
    }

    public void barrier() {
        if (this.userWasSet && !this.passwordWasSet) {
            this.password = "";
        }
        this.userWasSet = false;
        this.passwordWasSet = false;
    }

    public void setString(String string, String string2) throws ValidationError {
        Parameter parameter = Parameter.forName(string);
        if (parameter != null) {
            this.setString(parameter, string2);
        } else if (!Parameter.isIgnored(string)) {
            throw new ValidationError(string, "unknown parameter");
        }
    }

    public void setString(Parameter parameter, String string) throws ValidationError {
        if (string == null) {
            throw new NullPointerException("'value' must not be null");
        }
        this.assign(parameter, parameter.type.parse(parameter.name, string));
    }

    public void clear(Parameter parameter) {
        this.assign(parameter, parameter.getDefault());
    }

    public void parseUrl(String string) throws URISyntaxException, ValidationError {
        if (string == null) {
            return;
        }
        if (string.startsWith("jdbc:")) {
            string = string.substring(5);
        }
        if (string.equals("monetdb:")) {
            return;
        }
        MonetUrlParser.parse(this, string);
    }

    private void assign(Parameter parameter, Object object) {
        switch (parameter) {
            case TLS: {
                this.setTls((Boolean)object);
                break;
            }
            case HOST: {
                this.setHost((String)object);
                break;
            }
            case PORT: {
                this.setPort((Integer)object);
                break;
            }
            case DATABASE: {
                this.setDatabase((String)object);
                break;
            }
            case TABLESCHEMA: {
                this.setTableschema((String)object);
                break;
            }
            case TABLE: {
                this.setTable((String)object);
                break;
            }
            case SOCK: {
                this.setSock((String)object);
                break;
            }
            case SOCKDIR: {
                this.setSockdir((String)object);
                break;
            }
            case CERT: {
                this.setCert((String)object);
                break;
            }
            case CERTHASH: {
                this.setCerthash((String)object);
                break;
            }
            case CLIENTKEY: {
                this.setClientkey((String)object);
                break;
            }
            case CLIENTCERT: {
                this.setClientcert((String)object);
                break;
            }
            case USER: {
                this.setUser((String)object);
                break;
            }
            case PASSWORD: {
                this.setPassword((String)object);
                break;
            }
            case LANGUAGE: {
                this.setLanguage((String)object);
                break;
            }
            case AUTOCOMMIT: {
                this.setAutocommit((Boolean)object);
                break;
            }
            case SCHEMA: {
                this.setSchema((String)object);
                break;
            }
            case TIMEZONE: {
                this.setTimezone((Integer)object);
                break;
            }
            case BINARY: {
                this.setBinary((String)object);
                break;
            }
            case REPLYSIZE: {
                this.setReplySize((Integer)object);
                break;
            }
            case FETCHSIZE: {
                this.setReplySize((Integer)object);
                break;
            }
            case HASH: {
                this.setHash((String)object);
                break;
            }
            case DEBUG: {
                this.setDebug((Boolean)object);
                break;
            }
            case LOGFILE: {
                this.setLogfile((String)object);
                break;
            }
            case SO_TIMEOUT: {
                this.setSoTimeout((Integer)object);
                break;
            }
            case CLOB_AS_VARCHAR: {
                this.setTreatClobAsVarchar((Boolean)object);
                break;
            }
            case BLOB_AS_BINARY: {
                this.setTreatBlobAsBinary((Boolean)object);
                break;
            }
            case CLIENT_INFO: {
                this.setClientInfo((Boolean)object);
                break;
            }
            case CLIENT_APPLICATION: {
                this.setClientApplication((String)object);
                break;
            }
            case CLIENT_REMARK: {
                this.setClientRemark((String)object);
                break;
            }
            default: {
                throw new IllegalStateException("unreachable -- missing case: " + parameter.name);
            }
        }
    }

    public String getString(Parameter parameter) {
        Object object = this.getObject(parameter);
        return parameter.type.format(object);
    }

    public Object getObject(Parameter parameter) {
        switch (parameter) {
            case TLS: {
                return this.tls;
            }
            case HOST: {
                return this.host;
            }
            case PORT: {
                return this.port;
            }
            case DATABASE: {
                return this.database;
            }
            case TABLESCHEMA: {
                return this.tableschema;
            }
            case TABLE: {
                return this.table;
            }
            case SOCK: {
                return this.sock;
            }
            case SOCKDIR: {
                return this.sockdir;
            }
            case CERT: {
                return this.cert;
            }
            case CERTHASH: {
                return this.certhash;
            }
            case CLIENTKEY: {
                return this.clientkey;
            }
            case CLIENTCERT: {
                return this.clientcert;
            }
            case USER: {
                return this.user;
            }
            case PASSWORD: {
                return this.password;
            }
            case LANGUAGE: {
                return this.language;
            }
            case AUTOCOMMIT: {
                return this.autocommit;
            }
            case SCHEMA: {
                return this.schema;
            }
            case TIMEZONE: {
                return this.timezone;
            }
            case BINARY: {
                return this.binary;
            }
            case REPLYSIZE: {
                return this.replySize;
            }
            case FETCHSIZE: {
                return this.replySize;
            }
            case HASH: {
                return this.hash;
            }
            case DEBUG: {
                return this.debug;
            }
            case LOGFILE: {
                return this.logfile;
            }
            case SO_TIMEOUT: {
                return this.soTimeout;
            }
            case CLOB_AS_VARCHAR: {
                return this.treatClobAsVarchar;
            }
            case BLOB_AS_BINARY: {
                return this.treatBlobAsBinary;
            }
            case CLIENT_INFO: {
                return this.clientInfo;
            }
            case CLIENT_APPLICATION: {
                return this.clientApplication;
            }
            case CLIENT_REMARK: {
                return this.clientRemark;
            }
        }
        throw new IllegalStateException("unreachable -- missing case");
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean bl) {
        this.tls = bl;
        this.validated = null;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
        this.validated = null;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        this.validated = null;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String string) {
        this.database = string;
        this.validated = null;
    }

    public String getTableschema() {
        return this.tableschema;
    }

    public void setTableschema(String string) {
        this.tableschema = string;
        this.validated = null;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String string) {
        this.table = string;
        this.validated = null;
    }

    public String getSock() {
        return this.sock;
    }

    public void setSock(String string) {
        this.sock = string;
        this.validated = null;
    }

    public String getSockdir() {
        return this.sockdir;
    }

    public void setSockdir(String string) {
        this.sockdir = string;
        this.validated = null;
    }

    public String getCert() {
        return this.cert;
    }

    public void setCert(String string) {
        this.cert = string;
        this.validated = null;
    }

    public String getCerthash() {
        return this.certhash;
    }

    public void setCerthash(String string) {
        this.certhash = string;
        this.validated = null;
    }

    public String getClientkey() {
        return this.clientkey;
    }

    public void setClientkey(String string) {
        this.clientkey = string;
        this.validated = null;
    }

    public String getClientcert() {
        return this.clientcert;
    }

    public void setClientcert(String string) {
        this.clientcert = string;
        this.validated = null;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
        this.userWasSet = true;
        this.validated = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
        this.passwordWasSet = true;
        this.validated = null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
        this.validated = null;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
        this.validated = null;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        this.schema = string;
        this.validated = null;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public void setTimezone(int n) {
        this.timezone = n;
        this.validated = null;
    }

    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String string) {
        this.binary = string;
        this.validated = null;
    }

    public int getReplySize() {
        return this.replySize;
    }

    public void setReplySize(int n) {
        this.replySize = n;
        this.validated = null;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String string) {
        this.hash = string;
        this.validated = null;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.validated = null;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public void setLogfile(String string) {
        this.logfile = string;
        this.validated = null;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int n) {
        this.soTimeout = n;
        this.validated = null;
    }

    public boolean isTreatClobAsVarchar() {
        return this.treatClobAsVarchar;
    }

    public void setTreatClobAsVarchar(boolean bl) {
        this.treatClobAsVarchar = bl;
        this.validated = null;
    }

    public boolean isTreatBlobAsBinary() {
        return this.treatBlobAsBinary;
    }

    public void setTreatBlobAsBinary(boolean bl) {
        this.treatBlobAsBinary = bl;
        this.validated = null;
    }

    public boolean sendClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(boolean bl) {
        this.clientInfo = bl;
    }

    public String getClientApplication() {
        return this.clientApplication;
    }

    public void setClientApplication(String string) {
        this.clientApplication = string;
    }

    public String getClientRemark() {
        return this.clientRemark;
    }

    public void setClientRemark(String string) {
        this.clientRemark = string;
    }

    public Validated validate() throws ValidationError {
        if (this.validated == null) {
            this.validated = new Validated();
        }
        return this.validated;
    }

    public String buildUrl() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("jdbc:");
        stringBuilder.append(this.tls ? "monetdbs" : "monetdb");
        stringBuilder.append("://");
        stringBuilder.append(Target.packHost(this.host));
        if (!Parameter.PORT.getDefault().equals(this.port)) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
        stringBuilder.append('/').append(this.database);
        String string = "?";
        for (Parameter parameter : Parameter.values()) {
            Object object;
            Object object2;
            if (parameter.isCore || parameter == Parameter.USER || parameter == Parameter.PASSWORD || (object2 = parameter.getDefault()) == null || (object = this.getObject(parameter)).equals(object2)) continue;
            stringBuilder.append(string).append(parameter.name).append('=');
            String string2 = this.getString(parameter);
            String string3 = MonetUrlParser.percentEncode(string2);
            stringBuilder.append(string3);
            string = "&";
        }
        return stringBuilder.toString();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Parameter parameter : Parameter.values()) {
            Object object = parameter.getDefault();
            if (object == null || object.equals(this.getObject(parameter))) continue;
            String string = this.getString(parameter);
            if (parameter == Parameter.HOST) {
                string = Target.packHost(this.host);
            }
            properties.setProperty(parameter.name, string);
        }
        return properties;
    }

    public void setProperties(Properties properties) throws ValidationError {
        if (properties != null) {
            for (String string : properties.stringPropertyNames()) {
                String string2 = properties.getProperty(string);
                if (string.equals(Parameter.HOST.name)) {
                    string2 = Target.unpackHost(string2);
                }
                this.setString(string, string2);
            }
        }
    }

    public class Validated {
        private final int nbinary;

        Validated() throws ValidationError {
            int n;
            String string = Target.this.binary;
            try {
                n = (Integer)ParameterType.Int.parse(Parameter.BINARY.name, string);
            }
            catch (ValidationError validationError) {
                try {
                    boolean bl = (Boolean)ParameterType.Bool.parse(Parameter.BINARY.name, string);
                    n = bl ? 65535 : 0;
                }
                catch (ValidationError validationError2) {
                    throw new ValidationError("binary= must be either a number or true/yes/on/false/no/off");
                }
            }
            if (n < 0) {
                throw new ValidationError("binary= cannot be negative");
            }
            this.nbinary = n;
            if (!Target.this.sock.isEmpty() && !Target.this.host.isEmpty()) {
                throw new ValidationError("sock=" + Target.this.sock + " cannot be combined with host=" + Target.this.host);
            }
            if (!Target.this.sock.isEmpty() && Target.this.tls) {
                throw new ValidationError("monetdbs:// cannot be combined with sock=");
            }
            if (!Target.this.certhash.isEmpty()) {
                if (!Target.this.certhash.toLowerCase().startsWith("sha256:")) {
                    throw new ValidationError("certificate hash must start with 'sha256:'");
                }
                if (!hashPattern.matcher(Target.this.certhash).matches()) {
                    throw new ValidationError("invalid certificate hash");
                }
            }
            if (!(Target.this.tls || Target.this.cert.isEmpty() && Target.this.certhash.isEmpty())) {
                throw new ValidationError("cert= and certhash= are only allowed in combination with monetdbs://");
            }
            if (Target.this.database.isEmpty() && !Target.this.tableschema.isEmpty()) {
                throw new ValidationError("table schema cannot be set without database");
            }
            if (Target.this.tableschema.isEmpty() && !Target.this.table.isEmpty()) {
                throw new ValidationError("table cannot be set without schema");
            }
            if (!Target.this.database.isEmpty() && !namePattern.matcher(Target.this.database).matches()) {
                throw new ValidationError("invalid database name");
            }
            if (!Target.this.tableschema.isEmpty() && !namePattern.matcher(Target.this.tableschema).matches()) {
                throw new ValidationError("invalid table schema name");
            }
            if (!Target.this.table.isEmpty() && !namePattern.matcher(Target.this.table).matches()) {
                throw new ValidationError("invalid table name");
            }
            if (Target.this.port < -1 || Target.this.port == 0 || Target.this.port > 65535) {
                throw new ValidationError("invalid port number " + Target.this.port);
            }
            if (!Target.this.clientcert.isEmpty() && Target.this.clientkey.isEmpty()) {
                throw new ValidationError("clientcert= is only valid in combination with clientkey=");
            }
            if (Target.this.soTimeout < 0) {
                throw new ValidationError("so_timeout= must not be negative");
            }
        }

        public boolean getTls() {
            return Target.this.tls;
        }

        private String getHost() {
            return Target.this.host;
        }

        private int getPort() {
            return Target.this.port;
        }

        public String getDatabase() {
            return Target.this.database;
        }

        public String getTableschema() {
            return Target.this.tableschema;
        }

        public String getTable() {
            return Target.this.table;
        }

        private String getSock() {
            return Target.this.sock;
        }

        public String getSockdir() {
            return Target.this.sockdir;
        }

        public String getCert() {
            return Target.this.cert;
        }

        public String getCerthash() {
            return Target.this.certhash;
        }

        public String getClientkey() {
            return Target.this.clientkey;
        }

        public String getClientcert() {
            return Target.this.clientcert;
        }

        public String getUser() {
            return Target.this.user;
        }

        public String getPassword() {
            return Target.this.password;
        }

        public String getLanguage() {
            return Target.this.language;
        }

        public boolean isAutocommit() {
            return Target.this.autocommit;
        }

        public String getSchema() {
            return Target.this.schema;
        }

        public int getTimezone() {
            return Target.this.timezone;
        }

        public int getBinary() {
            return this.nbinary;
        }

        public int getReplySize() {
            return Target.this.replySize;
        }

        public String getHash() {
            return Target.this.hash;
        }

        public boolean isDebug() {
            return Target.this.debug;
        }

        public String getLogfile() {
            return Target.this.logfile;
        }

        public int getSoTimeout() {
            return Target.this.soTimeout;
        }

        public boolean isTreatClobAsVarchar() {
            return Target.this.treatClobAsVarchar;
        }

        public boolean isTreatBlobAsBinary() {
            return Target.this.treatBlobAsBinary;
        }

        public boolean sendClientInfo() {
            return Target.this.clientInfo;
        }

        public String getClientApplication() {
            return Target.this.clientApplication;
        }

        public String getClientRemark() {
            return Target.this.clientRemark;
        }

        public boolean connectScan() {
            if (Target.this.database.isEmpty()) {
                return false;
            }
            if (!Target.this.sock.isEmpty() || !Target.this.host.isEmpty() || Target.this.port != -1) {
                return false;
            }
            return !Target.this.tls;
        }

        public int connectPort() {
            return Target.this.port == -1 ? 50000 : Target.this.port;
        }

        public String connectUnix() {
            if (!Target.this.sock.isEmpty()) {
                return Target.this.sock;
            }
            if (Target.this.tls) {
                return "";
            }
            if (Target.this.host.isEmpty()) {
                return Target.this.sockdir + "/.s.monetdb." + this.connectPort();
            }
            return "";
        }

        public String connectTcp() {
            if (!Target.this.sock.isEmpty()) {
                return "";
            }
            if (Target.this.host.isEmpty()) {
                return "localhost";
            }
            return Target.this.host;
        }

        public Verify connectVerify() {
            if (!Target.this.tls) {
                return Verify.None;
            }
            if (!Target.this.certhash.isEmpty()) {
                return Verify.Hash;
            }
            if (!Target.this.cert.isEmpty()) {
                return Verify.Cert;
            }
            return Verify.System;
        }

        public String connectCertHashDigits() {
            if (!Target.this.tls) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(Target.this.certhash.length());
            for (int i = "sha256:".length(); i < Target.this.certhash.length(); ++i) {
                char c = Target.this.certhash.charAt(i);
                if (Character.digit(c, 16) < 0) continue;
                stringBuilder.append(Character.toLowerCase(c));
            }
            return stringBuilder.toString();
        }

        public int connectBinary() {
            return this.nbinary;
        }

        public String connectClientKey() {
            return Target.this.clientkey;
        }

        public String connectClientCert() {
            return Target.this.clientcert.isEmpty() ? Target.this.clientkey : Target.this.clientcert;
        }
    }

    public static enum Verify {
        None,
        Cert,
        Hash,
        System;

    }
}

