/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.logging;

import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.logging.LoggingSupport;
import org.apache.cassandra.utils.logging.NoOpFallbackLoggingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSupportFactory {
    private static final Logger logger = LoggerFactory.getLogger(LoggingSupportFactory.class);
    private static volatile LoggingSupport loggingSupport;

    private LoggingSupportFactory() {
    }

    public static LoggingSupport getLoggingSupport() {
        if (loggingSupport == null) {
            String loggerFactoryClass = LoggerFactory.getILoggerFactory().getClass().getName();
            if (loggerFactoryClass.contains("logback")) {
                loggingSupport = (LoggingSupport)FBUtilities.instanceOrConstruct("org.apache.cassandra.utils.logging.LogbackLoggingSupport", "LogbackLoggingSupport");
            } else {
                loggingSupport = new NoOpFallbackLoggingSupport();
                logger.warn("You are using Cassandra with an unsupported deployment. The intended logging implementation library logback is not used by slf4j. Detected slf4j logger factory: {}. You will not be able to dynamically manage log levels via JMX and may have performance or other issues.", (Object)loggerFactoryClass);
            }
        }
        return loggingSupport;
    }
}

