/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class IndexRange
implements Serializable {
    protected final int startIndex;
    protected final int endIndex;

    public IndexRange(int startIndex, int endIndex) {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((endIndex >= startIndex ? 1 : 0) != 0);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int size() {
        return this.endIndex - this.startIndex + 1;
    }

    public String toString() {
        return String.format("[%d, %d]", this.startIndex, this.endIndex);
    }

    public int hashCode() {
        return this.startIndex * 31 + this.endIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IndexRange that = (IndexRange)obj;
            return that.startIndex == this.startIndex && that.endIndex == this.endIndex;
        }
        return false;
    }
}

