/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.FileSystemJobResultStore;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator5.org.apache.curator.utils.ZKPaths;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.util.Preconditions;

public class ZooKeeperLeaderElectionHaServices
extends AbstractHaServices {
    private final CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper;

    public ZooKeeperLeaderElectionHaServices(CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper, Configuration configuration, Executor executor, BlobStoreService blobStoreService) throws Exception {
        super(configuration, new ZooKeeperLeaderElectionDriverFactory(ZooKeeperUtils.useNamespaceAndEnsurePath(curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getLeaderPath())), executor, blobStoreService, FileSystemJobResultStore.fromConfiguration(configuration, executor));
        this.curatorFrameworkWrapper = (CuratorFrameworkWithUnhandledErrorListener)Preconditions.checkNotNull((Object)curatorFrameworkWrapper);
    }

    @Override
    public CheckpointRecoveryFactory createCheckpointRecoveryFactory() throws Exception {
        return new ZooKeeperCheckpointRecoveryFactory(ZooKeeperUtils.useNamespaceAndEnsurePath(this.curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getJobsPath()), this.configuration, this.ioExecutor);
    }

    @Override
    public JobGraphStore createJobGraphStore() throws Exception {
        return ZooKeeperUtils.createJobGraphs(this.curatorFrameworkWrapper.asCuratorFramework(), this.configuration);
    }

    @Override
    protected void internalClose() {
        this.curatorFrameworkWrapper.close();
    }

    @Override
    protected void internalCleanup() throws Exception {
        this.cleanupZooKeeperPaths();
    }

    @Override
    protected void internalCleanupJobData(JobID jobID) throws Exception {
        this.deleteZNode(ZooKeeperUtils.getLeaderPathForJob(jobID));
    }

    private void cleanupZooKeeperPaths() throws Exception {
        this.deleteOwnedZNode();
        this.tryDeleteEmptyParentZNodes();
    }

    private void deleteOwnedZNode() throws Exception {
        this.deleteZNode("/");
    }

    protected void deleteZNode(String path) throws Exception {
        ZooKeeperUtils.deleteZNode(this.curatorFrameworkWrapper.asCuratorFramework(), path);
    }

    private void tryDeleteEmptyParentZNodes() throws Exception {
        String remainingPath = ZooKeeperLeaderElectionHaServices.getParentPath(ZooKeeperLeaderElectionHaServices.getNormalizedPath(this.curatorFrameworkWrapper.asCuratorFramework().getNamespace()));
        CuratorFramework nonNamespaceClient = this.curatorFrameworkWrapper.asCuratorFramework().usingNamespace(null);
        while (!ZooKeeperLeaderElectionHaServices.isRootPath(remainingPath)) {
            try {
                nonNamespaceClient.delete().forPath(remainingPath);
            }
            catch (KeeperException.NotEmptyException ignored) {
                break;
            }
            remainingPath = ZooKeeperLeaderElectionHaServices.getParentPath(remainingPath);
        }
    }

    private static boolean isRootPath(String remainingPath) {
        return "/".equals(remainingPath);
    }

    private static String getNormalizedPath(String path) {
        return ZKPaths.makePath((String)path, (String)"");
    }

    private static String getParentPath(String path) {
        return ZKPaths.getPathAndNode((String)path).getPath();
    }

    @Override
    protected LeaderRetrievalService createLeaderRetrievalService(String componentId) {
        return ZooKeeperUtils.createLeaderRetrievalService(this.curatorFrameworkWrapper.asCuratorFramework(), ZooKeeperUtils.getLeaderPath(componentId), this.configuration);
    }

    @Override
    protected String getLeaderPathForResourceManager() {
        return ZooKeeperUtils.getResourceManagerNode();
    }

    @Override
    protected String getLeaderPathForDispatcher() {
        return ZooKeeperUtils.getDispatcherNode();
    }

    @Override
    protected String getLeaderPathForJobManager(JobID jobID) {
        return "job-" + jobID.toString();
    }

    @Override
    protected String getLeaderPathForRestServer() {
        return ZooKeeperUtils.getRestServerNode();
    }
}

