/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;

public final class IDPattern
extends Pattern {
    private Expression idExpression;

    public IDPattern(Expression expression) {
        this.idExpression = expression;
    }

    public Pattern analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.idExpression = this.idExpression.typeCheck(staticContext, itemType);
        return this;
    }

    public int getDependencies() {
        return this.idExpression.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return this.idExpression.iterateSubExpressions();
    }

    public void promote(PromotionOffer promotionOffer) throws XPathException {
        this.idExpression = this.idExpression.promote(promotionOffer);
    }

    public boolean matches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        if (nodeInfo.getNodeKind() != 1) {
            return false;
        }
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            return false;
        }
        AtomicValue atomicValue = (AtomicValue)this.idExpression.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return false;
        }
        String string = atomicValue.getStringValue();
        if (string.indexOf(32) < 0 && string.indexOf(9) < 0 && string.indexOf(10) < 0 && string.indexOf(12) < 0) {
            NodeInfo nodeInfo2 = documentInfo.selectID(string);
            if (nodeInfo2 == null) {
                return false;
            }
            return nodeInfo2.isSameNodeInfo(nodeInfo);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            NodeInfo nodeInfo3 = documentInfo.selectID(string2);
            if (nodeInfo3 == null || !nodeInfo.isSameNodeInfo(nodeInfo3)) continue;
            return true;
        }
        return false;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeTest getNodeTest() {
        return NodeKindTest.ELEMENT;
    }
}

