/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.DataSetField;

@SearchableAnalyserPlugin(id="DataSetSearchableAnalyser", name="Search in data set metadata")
public class DataSetSearchableAnalyser
extends BaseMetadataSearchableAnalyser<DataSet>
implements ISearchableAnalyser<DataSet> {
    public List<ISearchResult> search(ISearchable<DataSet> searchable, ISearchQuery searchQuery) {
        DataSet set = (DataSet)searchable.getSearchableObject();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "name", set.getName(), null);
        this.matchProperty(searchable, results, searchQuery, "description", set.getDescription(), null);
        this.matchProperty(searchable, results, searchQuery, "folder-name", set.getFolderName(), null);
        this.matchProperty(searchable, results, searchQuery, "base-filename", set.getBaseFilename(), null);
        for (DataSetField field : set.getFields()) {
            this.matchProperty(searchable, results, searchQuery, "name of data set field: " + field.getFieldName(), field.getFieldName(), null);
            this.matchProperty(searchable, results, searchQuery, "type of data set field: " + field.getFieldName(), ValueMetaFactory.getValueMetaName((int)field.getType()), null);
            this.matchProperty(searchable, results, searchQuery, "format of data set field: " + field.getFieldName(), field.getFormat(), null);
            this.matchProperty(searchable, results, searchQuery, "comment of data set field: " + field.getFieldName(), field.getComment(), null);
        }
        return results;
    }

    public Class<DataSet> getSearchableClass() {
        return DataSet.class;
    }
}

