/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import java.util.Objects;
import org.apache.hop.core.util.Utils;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class FileItem {
    private static final String NO = "N";
    @HopMetadataProperty(key="name", injectionKeyDescription="GetFileNames.Injection.Filename.Label")
    private String fileName;
    @HopMetadataProperty(key="filemask", injectionKeyDescription="GetFileNames.Injection.Filemask.Label")
    private String fileMask;
    @HopMetadataProperty(key="exclude_filemask", injectionKeyDescription="GetFileNames.Injection.ExcludeFilemask.Label")
    private String excludeFileMask;
    @HopMetadataProperty(key="file_required", injectionKeyDescription="GetFileNames.Injection.FileRequired.Label")
    private String fileRequired;
    @HopMetadataProperty(key="include_subfolders", injectionKeyDescription="GetFileNames.Injection.IncludeSubDirs.Label")
    private String includeSubFolders;

    public FileItem() {
        this.setDefault();
    }

    public FileItem(String fileName, String fileMask, String excludeFileMask, String fileRequired, String includeSubFolders) {
        this.fileName = fileName;
        this.fileMask = fileMask;
        this.excludeFileMask = excludeFileMask;
        this.fileRequired = Utils.isEmpty((CharSequence)fileRequired) ? NO : fileRequired;
        this.includeSubFolders = Utils.isEmpty((CharSequence)includeSubFolders) ? NO : includeSubFolders;
    }

    protected void setDefault() {
        this.fileRequired = NO;
        this.includeSubFolders = NO;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public String getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String fileRequired) {
        this.fileRequired = fileRequired;
    }

    public String getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileItem fileItems = (FileItem)o;
        return this.fileName.equals(fileItems.fileName) && Objects.equals(this.fileMask, fileItems.fileMask) && Objects.equals(this.excludeFileMask, fileItems.excludeFileMask);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.fileMask, this.excludeFileMask);
    }
}

