/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.classfmt.NonNullDefaultAwareTypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.env.ITypeAnnotationWalker;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class BinaryTypeBinding
extends ReferenceBinding {
    private static final IBinaryMethod[] NO_BINARY_METHODS = new IBinaryMethod[0];
    protected ReferenceBinding superclass;
    protected ReferenceBinding enclosingType;
    protected ReferenceBinding[] superInterfaces;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    protected ReferenceBinding[] memberTypes;
    protected TypeVariableBinding[] typeVariables;
    private BinaryTypeBinding prototype;
    protected LookupEnvironment environment;
    protected SimpleLookupTable storedAnnotations = null;
    private ReferenceBinding containerAnnotationType;
    int defaultNullness = 0;
    public ExternalAnnotationStatus externalAnnotationStatus = ExternalAnnotationStatus.NOT_EEA_CONFIGURED;

    static Object convertMemberValue(Object binaryValue, LookupEnvironment env, char[][][] missingTypeNames, boolean resolveEnumConstants) {
        if (binaryValue == null) {
            return null;
        }
        if (binaryValue instanceof Constant) {
            return binaryValue;
        }
        if (binaryValue instanceof ClassSignature) {
            return env.getTypeFromSignature(((ClassSignature)binaryValue).getTypeName(), 0, -1, false, null, missingTypeNames, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
        }
        if (binaryValue instanceof IBinaryAnnotation) {
            return BinaryTypeBinding.createAnnotation((IBinaryAnnotation)binaryValue, env, missingTypeNames);
        }
        if (binaryValue instanceof EnumConstantSignature) {
            EnumConstantSignature ref = (EnumConstantSignature)binaryValue;
            ReferenceBinding enumType = (ReferenceBinding)env.getTypeFromSignature(ref.getTypeName(), 0, -1, false, null, missingTypeNames, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
            if (enumType.isUnresolvedType() && !resolveEnumConstants) {
                return new ElementValuePair.UnresolvedEnumConstant(enumType, env, ref.getEnumConstantName());
            }
            enumType = (ReferenceBinding)BinaryTypeBinding.resolveType(enumType, env, false);
            return enumType.getField(ref.getEnumConstantName(), false);
        }
        if (binaryValue instanceof Object[]) {
            Object[] objects = (Object[])binaryValue;
            int length = objects.length;
            if (length == 0) {
                return objects;
            }
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                values[i] = BinaryTypeBinding.convertMemberValue(objects[i], env, missingTypeNames, resolveEnumConstants);
                ++i;
            }
            return values;
        }
        throw new IllegalStateException();
    }

    @Override
    public TypeBinding clone(TypeBinding outerType) {
        BinaryTypeBinding copy = new BinaryTypeBinding(this);
        copy.enclosingType = (ReferenceBinding)outerType;
        copy.tagBits = copy.enclosingType != null ? (copy.tagBits |= 0x8000000L) : (copy.tagBits &= 0xFFFFFFFFF7FFFFFFL);
        copy.tagBits |= 0x10000000L;
        return copy;
    }

    static AnnotationBinding createAnnotation(IBinaryAnnotation annotationInfo, LookupEnvironment env, char[][][] missingTypeNames) {
        IBinaryElementValuePair[] binaryPairs = annotationInfo.getElementValuePairs();
        int length = binaryPairs == null ? 0 : binaryPairs.length;
        ElementValuePair[] pairs = length == 0 ? Binding.NO_ELEMENT_VALUE_PAIRS : new ElementValuePair[length];
        int i = 0;
        while (i < length) {
            pairs[i] = new ElementValuePair(binaryPairs[i].getName(), BinaryTypeBinding.convertMemberValue(binaryPairs[i].getValue(), env, missingTypeNames, false), null);
            ++i;
        }
        char[] typeName = annotationInfo.getTypeName();
        ReferenceBinding annotationType = env.getTypeFromConstantPoolName(typeName, 1, typeName.length - 1, false, missingTypeNames);
        return env.createUnresolvedAnnotation(annotationType, pairs);
    }

    public static AnnotationBinding[] createAnnotations(IBinaryAnnotation[] annotationInfos, LookupEnvironment env, char[][][] missingTypeNames) {
        int length = annotationInfos == null ? 0 : annotationInfos.length;
        AnnotationBinding[] result = length == 0 ? Binding.NO_ANNOTATIONS : new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            result[i] = BinaryTypeBinding.createAnnotation(annotationInfos[i], env, missingTypeNames);
            ++i;
        }
        return result;
    }

    public static TypeBinding resolveType(TypeBinding type, LookupEnvironment environment, boolean convertGenericToRawType) {
        switch (type.kind()) {
            case 260: {
                ((ParameterizedTypeBinding)type).resolve();
                break;
            }
            case 516: 
            case 8196: {
                return ((WildcardBinding)type).resolve();
            }
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)type;
                TypeBinding leafComponentType = arrayBinding.leafComponentType;
                BinaryTypeBinding.resolveType(leafComponentType, environment, convertGenericToRawType);
                if (!leafComponentType.hasNullTypeAnnotations() || !environment.usesNullTypeAnnotations()) break;
                if (arrayBinding.nullTagBitsPerDimension == null) {
                    arrayBinding.nullTagBitsPerDimension = new long[arrayBinding.dimensions + 1];
                }
                arrayBinding.nullTagBitsPerDimension[arrayBinding.dimensions] = leafComponentType.tagBits & 0x180000000000000L;
                break;
            }
            case 4100: {
                ((TypeVariableBinding)type).resolve();
                break;
            }
            case 2052: {
                if (!convertGenericToRawType) break;
                return environment.convertUnresolvedBinaryToRawType(type);
            }
            default: {
                if (type instanceof UnresolvedReferenceBinding) {
                    return ((UnresolvedReferenceBinding)type).resolve(environment, convertGenericToRawType);
                }
                if (!convertGenericToRawType) break;
                return environment.convertUnresolvedBinaryToRawType(type);
            }
        }
        return type;
    }

    protected BinaryTypeBinding() {
        this.prototype = this;
    }

    public BinaryTypeBinding(BinaryTypeBinding prototype) {
        super(prototype);
        this.superclass = prototype.superclass;
        this.enclosingType = prototype.enclosingType;
        this.superInterfaces = prototype.superInterfaces;
        this.fields = prototype.fields;
        this.methods = prototype.methods;
        this.memberTypes = prototype.memberTypes;
        this.typeVariables = prototype.typeVariables;
        this.prototype = prototype.prototype;
        this.environment = prototype.environment;
        this.storedAnnotations = prototype.storedAnnotations;
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType binaryType, LookupEnvironment environment) {
        this(packageBinding, binaryType, environment, false);
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType binaryType, LookupEnvironment environment, boolean needFieldsAndMethods) {
        this.prototype = this;
        this.compoundName = CharOperation.splitOn('/', binaryType.getName());
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = environment;
        this.fPackage = packageBinding;
        this.fileName = binaryType.getFileName();
        char[] typeSignature = binaryType.getGenericSignature();
        this.typeVariables = typeSignature != null && typeSignature.length > 0 && typeSignature[0] == '<' ? null : Binding.NO_TYPE_VARIABLES;
        this.sourceName = binaryType.getSourceName();
        this.modifiers = binaryType.getModifiers();
        if ((binaryType.getTagBits() & 0x20000L) != 0L) {
            this.tagBits |= 0x20000L;
        }
        if (binaryType.isAnonymous()) {
            this.tagBits |= 0x834L;
        } else if (binaryType.isLocal()) {
            this.tagBits |= 0x814L;
        } else if (binaryType.isMember()) {
            this.tagBits |= 0x80CL;
        }
        char[] enclosingTypeName = binaryType.getEnclosingTypeName();
        if (enclosingTypeName != null) {
            this.enclosingType = environment.getTypeFromConstantPoolName(enclosingTypeName, 0, -1, true, null);
            this.tagBits |= 0x80CL;
            this.tagBits |= 0x8000000L;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
        if (needFieldsAndMethods) {
            this.cachePartsFrom(binaryType, true);
        }
    }

    @Override
    public FieldBinding[] availableFields() {
        if (!this.isPrototype()) {
            return this.prototype.availableFields();
        }
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding[] availableFields = new FieldBinding[this.fields.length];
        int count = 0;
        int i = 0;
        while (i < this.fields.length) {
            try {
                availableFields[count] = this.resolveTypeFor(this.fields[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {}
            ++i;
        }
        if (count < availableFields.length) {
            FieldBinding[] fieldBindingArray = availableFields;
            availableFields = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, availableFields, 0, count);
        }
        return availableFields;
    }

    private TypeVariableBinding[] addMethodTypeVariables(TypeVariableBinding[] methodTypeVars) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.typeVariables == null || this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return methodTypeVars;
        }
        if (methodTypeVars == null || methodTypeVars == Binding.NO_TYPE_VARIABLES) {
            return this.typeVariables;
        }
        int total = this.typeVariables.length + methodTypeVars.length;
        TypeVariableBinding[] combinedTypeVars = new TypeVariableBinding[total];
        System.arraycopy(this.typeVariables, 0, combinedTypeVars, 0, this.typeVariables.length);
        int size = this.typeVariables.length;
        int i = 0;
        int len = methodTypeVars.length;
        while (i < len) {
            block7: {
                int j = this.typeVariables.length - 1;
                while (j >= 0) {
                    if (!CharOperation.equals(methodTypeVars[i].sourceName, this.typeVariables[j].sourceName)) {
                        --j;
                        continue;
                    }
                    break block7;
                }
                combinedTypeVars[size++] = methodTypeVars[i];
            }
            ++i;
        }
        if (size != total) {
            TypeVariableBinding[] typeVariableBindingArray = combinedTypeVars;
            combinedTypeVars = new TypeVariableBinding[size];
            System.arraycopy(typeVariableBindingArray, 0, combinedTypeVars, 0, size);
        }
        return combinedTypeVars;
    }

    @Override
    public MethodBinding[] availableMethods() {
        if (!this.isPrototype()) {
            return this.prototype.availableMethods();
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        MethodBinding[] availableMethods = new MethodBinding[this.methods.length];
        int count = 0;
        int i = 0;
        while (i < this.methods.length) {
            try {
                availableMethods[count] = this.resolveTypesFor(this.methods[i]);
                ++count;
            }
            catch (AbortCompilation abortCompilation) {}
            ++i;
        }
        if (count < availableMethods.length) {
            MethodBinding[] methodBindingArray = availableMethods;
            availableMethods = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, availableMethods, 0, count);
        }
        return availableMethods;
    }

    void cachePartsFrom(IBinaryType binaryType, boolean needFieldsAndMethods) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        try {
            boolean canUseNullTypeAnnotations;
            int i;
            int size;
            MethodBinding enclosingMethod;
            int size2;
            this.typeVariables = Binding.NO_TYPE_VARIABLES;
            this.superInterfaces = Binding.NO_SUPERINTERFACES;
            this.memberTypes = Binding.NO_MEMBER_TYPES;
            IBinaryNestedType[] memberTypeStructures = binaryType.getMemberTypes();
            if (memberTypeStructures != null && (size2 = memberTypeStructures.length) > 0) {
                this.memberTypes = new ReferenceBinding[size2];
                int i2 = 0;
                while (i2 < size2) {
                    this.memberTypes[i2] = this.environment.getTypeFromConstantPoolName(memberTypeStructures[i2].getName(), 0, -1, false, null);
                    ++i2;
                }
                this.tagBits |= 0x10000000L;
            }
            CompilerOptions globalOptions = this.environment.globalOptions;
            long sourceLevel = globalOptions.originalSourceLevel;
            if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                this.scanTypeForNullDefaultAnnotation(binaryType, this.fPackage);
            }
            ITypeAnnotationWalker walker = this.getTypeAnnotationWalker(binaryType.getTypeAnnotations(), 0);
            ITypeAnnotationWalker toplevelWalker = binaryType.enrichWithExternalAnnotationsFor(walker, null, this.environment);
            this.externalAnnotationStatus = binaryType.getExternalAnnotationStatus();
            if (this.externalAnnotationStatus.isPotentiallyUnannotatedLib() && this.defaultNullness != 0) {
                this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
            }
            char[] typeSignature = binaryType.getGenericSignature();
            this.tagBits |= binaryType.getTagBits();
            char[][][] missingTypeNames = binaryType.getMissingTypeNames();
            SignatureWrapper wrapper = null;
            if (typeSignature != null) {
                wrapper = new SignatureWrapper(typeSignature);
                if (wrapper.signature[wrapper.start] == '<') {
                    ++wrapper.start;
                    this.typeVariables = this.createTypeVariables(wrapper, true, missingTypeNames, toplevelWalker, true);
                    ++wrapper.start;
                    this.tagBits |= 0x1000000L;
                    this.modifiers |= 0x40000000;
                }
            }
            TypeVariableBinding[] typeVars = Binding.NO_TYPE_VARIABLES;
            char[] methodDescriptor = binaryType.getEnclosingMethod();
            if (methodDescriptor != null && (enclosingMethod = this.findMethod(methodDescriptor, missingTypeNames)) != null) {
                typeVars = enclosingMethod.typeVariables;
                this.typeVariables = this.addMethodTypeVariables(typeVars);
            }
            if (typeSignature == null) {
                char[] superclassName = binaryType.getSuperclassName();
                if (superclassName != null) {
                    this.superclass = this.environment.getTypeFromConstantPoolName(superclassName, 0, -1, false, missingTypeNames, toplevelWalker.toSupertype((short)-1, superclassName));
                    this.tagBits |= 0x2000000L;
                }
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                char[][] interfaceNames = binaryType.getInterfaceNames();
                if (interfaceNames != null && (size = interfaceNames.length) > 0) {
                    this.superInterfaces = new ReferenceBinding[size];
                    i = 0;
                    while (i < size) {
                        this.superInterfaces[i] = this.environment.getTypeFromConstantPoolName(interfaceNames[i], 0, -1, false, missingTypeNames, toplevelWalker.toSupertype((short)i, superclassName));
                        i = (short)(i + 1);
                    }
                    this.tagBits |= 0x4000000L;
                }
            } else {
                this.superclass = (ReferenceBinding)this.environment.getTypeFromTypeSignature(wrapper, typeVars, this, missingTypeNames, toplevelWalker.toSupertype((short)-1, wrapper.peekFullType()));
                this.tagBits |= 0x2000000L;
                this.superInterfaces = Binding.NO_SUPERINTERFACES;
                if (!wrapper.atEnd()) {
                    ArrayList<TypeBinding> types = new ArrayList<TypeBinding>(2);
                    short rank = 0;
                    do {
                        short s = rank;
                        rank = (short)(s + 1);
                        types.add(this.environment.getTypeFromTypeSignature(wrapper, typeVars, this, missingTypeNames, toplevelWalker.toSupertype(s, wrapper.peekFullType())));
                    } while (!wrapper.atEnd());
                    this.superInterfaces = new ReferenceBinding[types.size()];
                    types.toArray(this.superInterfaces);
                    this.tagBits |= 0x4000000L;
                }
            }
            boolean bl = canUseNullTypeAnnotations = this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled && this.environment.globalOptions.sourceLevel >= 0x340000L;
            if (canUseNullTypeAnnotations && this.externalAnnotationStatus.isPotentiallyUnannotatedLib()) {
                if (this.superclass != null && this.superclass.hasNullTypeAnnotations()) {
                    this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
                } else {
                    ReferenceBinding[] referenceBindingArray = this.superInterfaces;
                    i = this.superInterfaces.length;
                    size = 0;
                    while (size < i) {
                        ReferenceBinding ifc = referenceBindingArray[size];
                        if (ifc.hasNullTypeAnnotations()) {
                            this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
                            break;
                        }
                        ++size;
                    }
                }
            }
            if (needFieldsAndMethods) {
                IBinaryField[] iFields = binaryType.getFields();
                this.createFields(iFields, binaryType, sourceLevel, missingTypeNames);
                IBinaryMethod[] iMethods = this.createMethods(binaryType.getMethods(), binaryType, sourceLevel, missingTypeNames);
                boolean isViewedAsDeprecated = this.isViewedAsDeprecated();
                if (isViewedAsDeprecated) {
                    int i3 = 0;
                    int max = this.fields.length;
                    while (i3 < max) {
                        FieldBinding field = this.fields[i3];
                        if (!field.isDeprecated()) {
                            field.modifiers |= 0x200000;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    max = this.methods.length;
                    while (i3 < max) {
                        MethodBinding method = this.methods[i3];
                        if (!method.isDeprecated()) {
                            method.modifiers |= 0x200000;
                        }
                        ++i3;
                    }
                }
                if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                    if (iFields != null) {
                        int i4 = 0;
                        while (i4 < iFields.length) {
                            ITypeAnnotationWalker fieldWalker = ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
                            if (sourceLevel < 0x340000L) {
                                fieldWalker = binaryType.enrichWithExternalAnnotationsFor(walker, iFields[i4], this.environment);
                            }
                            this.scanFieldForNullAnnotation(iFields[i4], this.fields[i4], this.isEnum(), fieldWalker);
                            ++i4;
                        }
                    }
                    if (iMethods != null) {
                        int i5 = 0;
                        while (i5 < iMethods.length) {
                            ITypeAnnotationWalker methodWalker = ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
                            if (sourceLevel < 0x340000L) {
                                methodWalker = binaryType.enrichWithExternalAnnotationsFor(methodWalker, iMethods[i5], this.environment);
                            }
                            this.scanMethodForNullAnnotation(iMethods[i5], this.methods[i5], methodWalker, canUseNullTypeAnnotations);
                            ++i5;
                        }
                    }
                }
            }
            if (this.environment.globalOptions.storeAnnotations) {
                this.setAnnotations(BinaryTypeBinding.createAnnotations(binaryType.getAnnotations(), this.environment, missingTypeNames));
            }
            if (this.isAnnotationType()) {
                this.scanTypeForContainerAnnotation(binaryType, missingTypeNames);
            }
        }
        finally {
            if (this.fields == null) {
                this.fields = Binding.NO_FIELDS;
            }
            if (this.methods == null) {
                this.methods = Binding.NO_METHODS;
            }
        }
    }

    private ITypeAnnotationWalker getTypeAnnotationWalker(IBinaryTypeAnnotation[] annotations, int nullness) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (annotations == null || annotations.length == 0 || !this.environment.usesAnnotatedTypeSystem()) {
            if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
                if (nullness == 0) {
                    nullness = this.getNullDefault();
                }
                if (nullness > 2) {
                    return new NonNullDefaultAwareTypeAnnotationWalker(nullness, this.environment);
                }
            }
            return ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER;
        }
        if (this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled) {
            if (nullness == 0) {
                nullness = this.getNullDefault();
            }
            if (nullness > 2) {
                return new NonNullDefaultAwareTypeAnnotationWalker(annotations, nullness, this.environment);
            }
        }
        return new TypeAnnotationWalker(annotations);
    }

    private int getNullDefaultFrom(IBinaryAnnotation[] declAnnotations) {
        if (declAnnotations != null) {
            IBinaryAnnotation[] iBinaryAnnotationArray = declAnnotations;
            int n = declAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                IBinaryAnnotation annotation = iBinaryAnnotationArray[n2];
                char[][] typeName = this.signature2qualifiedTypeName(annotation.getTypeName());
                if (this.environment.getNullAnnotationBit(typeName) == 128) {
                    return this.getNonNullByDefaultValue(annotation);
                }
                ++n2;
            }
        }
        return 0;
    }

    private void createFields(IBinaryField[] iFields, IBinaryType binaryType, long sourceLevel, char[][][] missingTypeNames) {
        int size;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.fields = Binding.NO_FIELDS;
        if (iFields != null && (size = iFields.length) > 0) {
            IBinaryField binaryField;
            FieldBinding[] fields1 = new FieldBinding[size];
            boolean use15specifics = sourceLevel >= 0x310000L;
            boolean hasRestrictedAccess = this.hasRestrictedAccess();
            int firstAnnotatedFieldIndex = -1;
            int i = 0;
            while (i < size) {
                binaryField = iFields[i];
                char[] fieldSignature = use15specifics ? binaryField.getGenericSignature() : null;
                ITypeAnnotationWalker walker = this.getTypeAnnotationWalker(binaryField.getTypeAnnotations(), 0);
                if (sourceLevel >= 0x340000L) {
                    walker = binaryType.enrichWithExternalAnnotationsFor(walker, iFields[i], this.environment);
                }
                walker = walker.toField();
                TypeBinding type = fieldSignature == null ? this.environment.getTypeFromSignature(binaryField.getTypeName(), 0, -1, false, this, missingTypeNames, walker) : this.environment.getTypeFromTypeSignature(new SignatureWrapper(fieldSignature), Binding.NO_TYPE_VARIABLES, this, missingTypeNames, walker);
                FieldBinding field = new FieldBinding(binaryField.getName(), type, binaryField.getModifiers() | 0x2000000, this, binaryField.getConstant());
                if (firstAnnotatedFieldIndex < 0 && this.environment.globalOptions.storeAnnotations && binaryField.getAnnotations() != null) {
                    firstAnnotatedFieldIndex = i;
                }
                field.id = i;
                if (use15specifics) {
                    field.tagBits |= binaryField.getTagBits();
                }
                if (hasRestrictedAccess) {
                    field.modifiers |= 0x40000;
                }
                if (fieldSignature != null) {
                    field.modifiers |= 0x40000000;
                }
                fields1[i] = field;
                ++i;
            }
            this.fields = fields1;
            if (firstAnnotatedFieldIndex >= 0) {
                i = firstAnnotatedFieldIndex;
                while (i < size) {
                    binaryField = iFields[i];
                    this.fields[i].setAnnotations(BinaryTypeBinding.createAnnotations(binaryField.getAnnotations(), this.environment, missingTypeNames));
                    ++i;
                }
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod method, IBinaryType binaryType, long sourceLevel, char[][][] missingTypeNames) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int methodModifiers = method.getModifiers() | 0x2000000;
        if (sourceLevel < 0x310000L) {
            methodModifiers &= 0xFFFFFF7F;
        }
        if (this.isInterface() && (methodModifiers & 0x400) == 0 && (methodModifiers & 8) == 0) {
            methodModifiers |= 0x10000;
        }
        ReferenceBinding[] exceptions = Binding.NO_EXCEPTIONS;
        TypeBinding[] parameters = Binding.NO_PARAMETERS;
        TypeVariableBinding[] typeVars = Binding.NO_TYPE_VARIABLES;
        AnnotationBinding[][] paramAnnotations = null;
        TypeBinding returnType = null;
        Object argumentNames = method.getArgumentNames();
        boolean use15specifics = sourceLevel >= 0x310000L;
        ITypeAnnotationWalker walker = this.getTypeAnnotationWalker(method.getTypeAnnotations(), this.getNullDefaultFrom(method.getAnnotations()));
        char[] methodSignature = method.getGenericSignature();
        if (methodSignature == null) {
            int argumentNamesLength;
            char[][] exceptionTypes;
            int size;
            char nextChar;
            char[] methodDescriptor = method.getMethodDescriptor();
            if (sourceLevel >= 0x340000L) {
                walker = binaryType.enrichWithExternalAnnotationsFor(walker, method, this.environment);
            }
            int numOfParams = 0;
            int index = 0;
            while ((nextChar = methodDescriptor[++index]) != ')') {
                if (nextChar == '[') continue;
                ++numOfParams;
                if (nextChar != 'L') continue;
                while ((nextChar = methodDescriptor[++index]) != ';') {
                }
            }
            int startIndex = 0;
            if (method.isConstructor()) {
                if (this.isMemberType() && !this.isStatic()) {
                    ++startIndex;
                }
                if (this.isEnum()) {
                    startIndex += 2;
                }
            }
            if ((size = numOfParams - startIndex) > 0) {
                parameters = new TypeBinding[size];
                if (this.environment.globalOptions.storeAnnotations) {
                    paramAnnotations = new AnnotationBinding[size][];
                }
                index = 1;
                short visibleIdx = 0;
                int end = 0;
                int i = 0;
                while (i < numOfParams) {
                    while ((nextChar = methodDescriptor[++end]) == '[') {
                    }
                    if (nextChar == 'L') {
                        while ((nextChar = methodDescriptor[++end]) != ';') {
                        }
                    }
                    if (i >= startIndex) {
                        short s = visibleIdx;
                        visibleIdx = (short)(s + 1);
                        parameters[i - startIndex] = this.environment.getTypeFromSignature(methodDescriptor, index, end, false, this, missingTypeNames, walker.toMethodParameter(s));
                        if (paramAnnotations != null) {
                            paramAnnotations[i - startIndex] = BinaryTypeBinding.createAnnotations(method.getParameterAnnotations(i - startIndex, this.fileName), this.environment, missingTypeNames);
                        }
                    }
                    index = end + 1;
                    ++i;
                }
            }
            if ((exceptionTypes = method.getExceptionTypeNames()) != null && (size = exceptionTypes.length) > 0) {
                exceptions = new ReferenceBinding[size];
                int i = 0;
                while (i < size) {
                    exceptions[i] = this.environment.getTypeFromConstantPoolName(exceptionTypes[i], 0, -1, false, missingTypeNames, walker.toThrows(i));
                    ++i;
                }
            }
            if (!method.isConstructor()) {
                returnType = this.environment.getTypeFromSignature(methodDescriptor, index + 1, -1, false, this, missingTypeNames, walker.toMethodReturn());
            }
            int n = argumentNamesLength = argumentNames == null ? 0 : ((char[][])argumentNames).length;
            if (startIndex > 0 && argumentNamesLength > 0) {
                if (startIndex >= argumentNamesLength) {
                    argumentNames = Binding.NO_PARAMETER_NAMES;
                } else {
                    char[][] slicedArgumentNames = new char[argumentNamesLength - startIndex][];
                    System.arraycopy(argumentNames, startIndex, slicedArgumentNames, 0, argumentNamesLength - startIndex);
                    argumentNames = slicedArgumentNames;
                }
            }
        } else {
            ArrayList<TypeBinding> types;
            if (sourceLevel >= 0x340000L) {
                walker = binaryType.enrichWithExternalAnnotationsFor(walker, method, this.environment);
            }
            methodModifiers |= 0x40000000;
            SignatureWrapper wrapper = new SignatureWrapper(methodSignature, use15specifics);
            if (wrapper.signature[wrapper.start] == '<') {
                ++wrapper.start;
                typeVars = this.createTypeVariables(wrapper, false, missingTypeNames, walker, false);
                ++wrapper.start;
            }
            if (wrapper.signature[wrapper.start] == '(') {
                ++wrapper.start;
                if (wrapper.signature[wrapper.start] == ')') {
                    ++wrapper.start;
                } else {
                    types = new ArrayList<TypeBinding>(2);
                    short rank = 0;
                    while (wrapper.signature[wrapper.start] != ')') {
                        short s = rank;
                        rank = (short)(s + 1);
                        types.add(this.environment.getTypeFromTypeSignature(wrapper, typeVars, this, missingTypeNames, walker.toMethodParameter(s)));
                    }
                    ++wrapper.start;
                    int numParam = types.size();
                    parameters = new TypeBinding[numParam];
                    types.toArray(parameters);
                    if (this.environment.globalOptions.storeAnnotations) {
                        paramAnnotations = new AnnotationBinding[numParam][];
                        int i = 0;
                        while (i < numParam) {
                            paramAnnotations[i] = BinaryTypeBinding.createAnnotations(method.getParameterAnnotations(i, this.fileName), this.environment, missingTypeNames);
                            ++i;
                        }
                    }
                }
            }
            returnType = this.environment.getTypeFromTypeSignature(wrapper, typeVars, this, missingTypeNames, walker.toMethodReturn());
            if (!wrapper.atEnd() && wrapper.signature[wrapper.start] == '^') {
                types = new ArrayList(2);
                int excRank = 0;
                do {
                    ++wrapper.start;
                    types.add(this.environment.getTypeFromTypeSignature(wrapper, typeVars, this, missingTypeNames, walker.toThrows(excRank++)));
                } while (!wrapper.atEnd() && wrapper.signature[wrapper.start] == '^');
                exceptions = new ReferenceBinding[types.size()];
                types.toArray(exceptions);
            } else {
                int size;
                char[][] exceptionTypes = method.getExceptionTypeNames();
                if (exceptionTypes != null && (size = exceptionTypes.length) > 0) {
                    exceptions = new ReferenceBinding[size];
                    int i = 0;
                    while (i < size) {
                        exceptions[i] = this.environment.getTypeFromConstantPoolName(exceptionTypes[i], 0, -1, false, missingTypeNames, walker.toThrows(i));
                        ++i;
                    }
                }
            }
        }
        MethodBinding result = method.isConstructor() ? new MethodBinding(methodModifiers, parameters, exceptions, this) : new MethodBinding(methodModifiers, method.getSelector(), returnType, parameters, exceptions, this);
        IBinaryAnnotation[] receiverAnnotations = walker.toReceiver().getAnnotationsAtCursor(this.id);
        if (receiverAnnotations != null && receiverAnnotations.length > 0) {
            result.receiver = this.environment.createAnnotatedType((TypeBinding)this, BinaryTypeBinding.createAnnotations(receiverAnnotations, this.environment, missingTypeNames));
        }
        if (this.environment.globalOptions.storeAnnotations) {
            IBinaryAnnotation[] annotations = method.getAnnotations();
            if ((annotations == null || annotations.length == 0) && method.isConstructor()) {
                annotations = walker.toMethodReturn().getAnnotationsAtCursor(this.id);
            }
            result.setAnnotations(BinaryTypeBinding.createAnnotations(annotations, this.environment, missingTypeNames), paramAnnotations, this.isAnnotationType() ? BinaryTypeBinding.convertMemberValue(method.getDefaultValue(), this.environment, missingTypeNames, true) : null, this.environment);
        }
        if (argumentNames != null) {
            result.parameterNames = argumentNames;
        }
        if (use15specifics) {
            result.tagBits |= method.getTagBits();
        }
        result.typeVariables = typeVars;
        int i = 0;
        int length = typeVars.length;
        while (i < length) {
            this.environment.typeSystem.fixTypeVariableDeclaringElement(typeVars[i], result);
            ++i;
        }
        return result;
    }

    private IBinaryMethod[] createMethods(IBinaryMethod[] iMethods, IBinaryType binaryType, long sourceLevel, char[][][] missingTypeNames) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int total = 0;
        int initialTotal = 0;
        int iClinit = -1;
        int[] toSkip = null;
        if (iMethods != null) {
            total = initialTotal = iMethods.length;
            boolean keepBridgeMethods = sourceLevel < 0x310000L;
            int i = total;
            while (--i >= 0) {
                char[] methodName;
                IBinaryMethod method = iMethods[i];
                if ((method.getModifiers() & 0x1000) != 0) {
                    if (keepBridgeMethods && (method.getModifiers() & 0x40) != 0) continue;
                    if (toSkip == null) {
                        toSkip = new int[iMethods.length];
                    }
                    toSkip[i] = -1;
                    --total;
                    continue;
                }
                if (iClinit != -1 || (methodName = method.getSelector()).length != 8 || methodName[0] != '<') continue;
                iClinit = i;
                --total;
            }
        }
        if (total == 0) {
            this.methods = Binding.NO_METHODS;
            return NO_BINARY_METHODS;
        }
        boolean hasRestrictedAccess = this.hasRestrictedAccess();
        MethodBinding[] methods1 = new MethodBinding[total];
        if (total == initialTotal) {
            int i = 0;
            while (i < initialTotal) {
                MethodBinding method = this.createMethod(iMethods[i], binaryType, sourceLevel, missingTypeNames);
                if (hasRestrictedAccess) {
                    method.modifiers |= 0x40000;
                }
                methods1[i] = method;
                ++i;
            }
            this.methods = methods1;
            return iMethods;
        }
        IBinaryMethod[] mappedBinaryMethods = new IBinaryMethod[total];
        int i = 0;
        int index = 0;
        while (i < initialTotal) {
            if (iClinit != i && (toSkip == null || toSkip[i] != -1)) {
                MethodBinding method = this.createMethod(iMethods[i], binaryType, sourceLevel, missingTypeNames);
                if (hasRestrictedAccess) {
                    method.modifiers |= 0x40000;
                }
                mappedBinaryMethods[index] = iMethods[i];
                methods1[index++] = method;
            }
            ++i;
        }
        this.methods = methods1;
        return mappedBinaryMethods;
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper wrapper, boolean assignVariables, char[][][] missingTypeNames, ITypeAnnotationWalker walker, boolean isClassTypeParameter) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        char[] typeSignature = wrapper.signature;
        int depth = 0;
        int length = typeSignature.length;
        int rank = 0;
        ArrayList<TypeVariableBinding> variables = new ArrayList<TypeVariableBinding>(1);
        depth = 0;
        boolean pendingVariable = true;
        int i = 1;
        block5: while (i < length) {
            switch (typeSignature[i]) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    if (--depth >= 0) break;
                    break block5;
                }
                case ';': {
                    if (depth != 0 || i + 1 >= length || typeSignature[i + 1] == ':') break;
                    pendingVariable = true;
                    break;
                }
                default: {
                    AnnotationBinding[] annotations;
                    if (!pendingVariable) break;
                    pendingVariable = false;
                    int colon = CharOperation.indexOf(':', typeSignature, i);
                    char[] variableName = CharOperation.subarray(typeSignature, i, colon);
                    TypeVariableBinding typeVariable = new TypeVariableBinding(variableName, this, rank, this.environment);
                    if ((annotations = BinaryTypeBinding.createAnnotations(walker.toTypeParameter(isClassTypeParameter, rank++).getAnnotationsAtCursor(0), this.environment, missingTypeNames)) != null && annotations != Binding.NO_ANNOTATIONS) {
                        typeVariable.setTypeAnnotations(annotations, this.environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
                    }
                    variables.add(typeVariable);
                }
            }
            ++i;
        }
        TypeVariableBinding[] result = new TypeVariableBinding[rank];
        variables.toArray(result);
        if (assignVariables) {
            this.typeVariables = result;
        }
        int i2 = 0;
        while (i2 < rank) {
            this.initializeTypeVariable(result[i2], result, wrapper, missingTypeNames, walker.toTypeParameterBounds(isClassTypeParameter, i2));
            if (this.externalAnnotationStatus.isPotentiallyUnannotatedLib() && result[i2].hasNullTypeAnnotations()) {
                this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
            }
            ++i2;
        }
        return result;
    }

    @Override
    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        return this.enclosingType;
    }

    @Override
    public FieldBinding[] fields() {
        if (!this.isPrototype()) {
            this.fields = this.prototype.fields();
            return this.fields;
        }
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.fields;
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        int i = this.fields.length;
        while (--i >= 0) {
            this.resolveTypeFor(this.fields[i]);
        }
        this.tagBits |= 0x2000L;
        return this.fields;
    }

    private MethodBinding findMethod(char[] methodDescriptor, char[][][] missingTypeNames) {
        char nextChar;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int index = -1;
        while (methodDescriptor[++index] != '(') {
        }
        char[] selector = new char[index];
        System.arraycopy(methodDescriptor, 0, selector, 0, index);
        TypeBinding[] parameters = Binding.NO_PARAMETERS;
        int numOfParams = 0;
        int paramStart = index;
        while ((nextChar = methodDescriptor[++index]) != ')') {
            if (nextChar == '[') continue;
            ++numOfParams;
            if (nextChar != 'L') continue;
            while ((nextChar = methodDescriptor[++index]) != ';') {
            }
        }
        if (numOfParams > 0) {
            parameters = new TypeBinding[numOfParams];
            index = paramStart + 1;
            int end = paramStart;
            int i = 0;
            while (i < numOfParams) {
                TypeBinding param;
                while ((nextChar = methodDescriptor[++end]) == '[') {
                }
                if (nextChar == 'L') {
                    while ((nextChar = methodDescriptor[++end]) != ';') {
                    }
                }
                if ((param = this.environment.getTypeFromSignature(methodDescriptor, index, end, false, this, missingTypeNames, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER)) instanceof UnresolvedReferenceBinding) {
                    param = BinaryTypeBinding.resolveType(param, this.environment, true);
                }
                parameters[i] = param;
                index = end + 1;
                ++i;
            }
        }
        int parameterLength = parameters.length;
        MethodBinding[] methods2 = this.enclosingType.getMethods(selector, parameterLength);
        int i = 0;
        int max = methods2.length;
        while (i < max) {
            block14: {
                MethodBinding currentMethod = methods2[i];
                TypeBinding[] parameters2 = currentMethod.parameters;
                int currentMethodParameterLength = parameters2.length;
                if (parameterLength == currentMethodParameterLength) {
                    int j = 0;
                    while (j < currentMethodParameterLength) {
                        if (!TypeBinding.notEquals(parameters[j], parameters2[j]) || !TypeBinding.notEquals(parameters[j].erasure(), parameters2[j].erasure())) {
                            ++j;
                            continue;
                        }
                        break block14;
                    }
                    return currentMethod;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public char[] genericTypeSignature() {
        if (!this.isPrototype()) {
            return this.prototype.computeGenericTypeSignature(this.typeVariables);
        }
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    @Override
    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        if (!this.isPrototype()) {
            return this.prototype.getExactConstructor(argumentTypes);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int argCount = argumentTypes.length;
        long range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
        if (range >= 0L) {
            int imethod = (int)range;
            int end = (int)(range >> 32);
            while (imethod <= end) {
                block8: {
                    MethodBinding method = this.methods[imethod];
                    if (method.parameters.length == argCount) {
                        this.resolveTypesFor(method);
                        TypeBinding[] toMatch = method.parameters;
                        int iarg = 0;
                        while (iarg < argCount) {
                            if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                ++iarg;
                                continue;
                            }
                            break block8;
                        }
                        return method;
                    }
                }
                ++imethod;
            }
        }
        return null;
    }

    @Override
    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (!this.isPrototype()) {
            return this.prototype.getExactMethod(selector, argumentTypes, refScope);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int argCount = argumentTypes.length;
        boolean foundNothing = true;
        long range = ReferenceBinding.binarySearch(selector, this.methods);
        if (range >= 0L) {
            int imethod = (int)range;
            int end = (int)(range >> 32);
            while (imethod <= end) {
                block15: {
                    MethodBinding method = this.methods[imethod];
                    foundNothing = false;
                    if (method.parameters.length == argCount) {
                        this.resolveTypesFor(method);
                        TypeBinding[] toMatch = method.parameters;
                        int iarg = 0;
                        while (iarg < argCount) {
                            if (!TypeBinding.notEquals(toMatch[iarg], argumentTypes[iarg])) {
                                ++iarg;
                                continue;
                            }
                            break block15;
                        }
                        return method;
                    }
                }
                ++imethod;
            }
        }
        if (foundNothing) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (refScope != null) {
                        refScope.recordTypeReference(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(selector, argumentTypes, refScope);
                }
            } else if (this.superclass() != null) {
                if (refScope != null) {
                    refScope.recordTypeReference(this.superclass);
                }
                return this.superclass.getExactMethod(selector, argumentTypes, refScope);
            }
        }
        return null;
    }

    @Override
    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if (!this.isPrototype()) {
            return this.prototype.getField(fieldName, needResolve);
        }
        if ((this.tagBits & 0x1000L) == 0L) {
            int length = this.fields.length;
            if (length > 1) {
                ReferenceBinding.sortFields(this.fields, 0, length);
            }
            this.tagBits |= 0x1000L;
        }
        FieldBinding field = ReferenceBinding.binarySearch(fieldName, this.fields);
        return needResolve && field != null ? this.resolveTypeFor(field) : field;
    }

    @Override
    public ReferenceBinding getMemberType(char[] typeName) {
        if (!this.isPrototype()) {
            ReferenceBinding memberType = this.prototype.getMemberType(typeName);
            return memberType == null ? null : this.environment.createMemberType(memberType, this);
        }
        int i = this.memberTypes.length;
        while (--i >= 0) {
            ReferenceBinding memberType = this.memberTypes[i];
            if (memberType instanceof UnresolvedReferenceBinding) {
                char[] name = memberType.sourceName;
                int prefixLength = this.compoundName[this.compoundName.length - 1].length + 1;
                if (name.length != prefixLength + typeName.length || !CharOperation.fragmentEquals(typeName, name, prefixLength, true)) continue;
                this.memberTypes[i] = (ReferenceBinding)BinaryTypeBinding.resolveType(memberType, this.environment, false);
                return this.memberTypes[i];
            }
            if (!CharOperation.equals(typeName, memberType.sourceName)) continue;
            return memberType;
        }
        return null;
    }

    @Override
    public MethodBinding[] getMethods(char[] selector) {
        long range;
        if (!this.isPrototype()) {
            return this.prototype.getMethods(selector);
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            long range2 = ReferenceBinding.binarySearch(selector, this.methods);
            if (range2 >= 0L) {
                int start = (int)range2;
                int end = (int)(range2 >> 32);
                int length = end - start + 1;
                if ((this.tagBits & 0x8000L) != 0L) {
                    MethodBinding[] result = new MethodBinding[length];
                    System.arraycopy(this.methods, start, result, 0, length);
                    return result;
                }
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            int start = (int)range;
            int end = (int)(range >> 32);
            int length = end - start + 1;
            MethodBinding[] result = new MethodBinding[length];
            int i = start;
            int index = 0;
            while (i <= end) {
                result[index] = this.resolveTypesFor(this.methods[i]);
                ++i;
                ++index;
            }
            return result;
        }
        return Binding.NO_METHODS;
    }

    @Override
    public MethodBinding[] getMethods(char[] selector, int suggestedParameterLength) {
        long range;
        if (!this.isPrototype()) {
            return this.prototype.getMethods(selector, suggestedParameterLength);
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.getMethods(selector);
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            int i;
            int start = (int)range;
            int end = (int)(range >> 32);
            int length = end - start + 1;
            int count = 0;
            int i2 = start;
            while (i2 <= end) {
                int len = this.methods[i2].parameters.length;
                if (len <= suggestedParameterLength || this.methods[i2].isVarargs() && len == suggestedParameterLength + 1) {
                    ++count;
                }
                ++i2;
            }
            if (count == 0) {
                MethodBinding[] result = new MethodBinding[length];
                i = start;
                int index = 0;
                while (i <= end) {
                    result[index++] = this.resolveTypesFor(this.methods[i]);
                    ++i;
                }
                return result;
            }
            MethodBinding[] result = new MethodBinding[count];
            i = start;
            int index = 0;
            while (i <= end) {
                int len = this.methods[i].parameters.length;
                if (len <= suggestedParameterLength || this.methods[i].isVarargs() && len == suggestedParameterLength + 1) {
                    result[index++] = this.resolveTypesFor(this.methods[i]);
                }
                ++i;
            }
            return result;
        }
        return Binding.NO_METHODS;
    }

    @Override
    public boolean hasMemberTypes() {
        if (!this.isPrototype()) {
            return this.prototype.hasMemberTypes();
        }
        return this.memberTypes.length > 0;
    }

    @Override
    public TypeVariableBinding getTypeVariable(char[] variableName) {
        if (!this.isPrototype()) {
            return this.prototype.getTypeVariable(variableName);
        }
        TypeVariableBinding variable = super.getTypeVariable(variableName);
        variable.resolve();
        return variable;
    }

    @Override
    public boolean hasTypeBit(int bit) {
        if (!this.isPrototype()) {
            return this.prototype.hasTypeBit(bit);
        }
        boolean wasToleratingMissingTypeProcessingAnnotations = this.environment.mayTolerateMissingType;
        this.environment.mayTolerateMissingType = true;
        try {
            this.superclass();
            this.superInterfaces();
        }
        finally {
            this.environment.mayTolerateMissingType = wasToleratingMissingTypeProcessingAnnotations;
        }
        return (this.typeBits & bit) != 0;
    }

    private void initializeTypeVariable(TypeVariableBinding variable, TypeVariableBinding[] existingVariables, SignatureWrapper wrapper, char[][][] missingTypeNames, ITypeAnnotationWalker walker) {
        ReferenceBinding type;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        int colon = CharOperation.indexOf(':', wrapper.signature, wrapper.start);
        wrapper.start = colon + 1;
        ReferenceBinding firstBound = null;
        short rank = 0;
        if (wrapper.signature[wrapper.start] == ':') {
            type = this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            rank = (short)(rank + 1);
        } else {
            short s = rank;
            rank = (short)(s + 1);
            TypeBinding typeFromTypeSignature = this.environment.getTypeFromTypeSignature(wrapper, existingVariables, this, missingTypeNames, walker.toTypeBound(s));
            type = typeFromTypeSignature instanceof ReferenceBinding ? (ReferenceBinding)typeFromTypeSignature : this.environment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            firstBound = type;
        }
        variable.modifiers |= 0x2000000;
        variable.setSuperClass(type);
        ReferenceBinding[] bounds = null;
        if (wrapper.signature[wrapper.start] == ':') {
            ArrayList<TypeBinding> types = new ArrayList<TypeBinding>(2);
            do {
                ++wrapper.start;
                short s = rank;
                rank = (short)(s + 1);
                types.add(this.environment.getTypeFromTypeSignature(wrapper, existingVariables, this, missingTypeNames, walker.toTypeBound(s)));
            } while (wrapper.signature[wrapper.start] == ':');
            bounds = new ReferenceBinding[types.size()];
            types.toArray(bounds);
        }
        variable.setSuperInterfaces(bounds == null ? Binding.NO_SUPERINTERFACES : bounds);
        if (firstBound == null) {
            firstBound = variable.superInterfaces.length == 0 ? null : variable.superInterfaces[0];
        }
        variable.setFirstBound(firstBound);
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        if (TypeBinding.equalsEquals(this, otherType)) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 516: 
            case 8196: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 260: 
            case 1028: {
                return TypeBinding.equalsEquals(otherType.erasure(), this);
            }
        }
        return false;
    }

    @Override
    public boolean isGenericType() {
        if (!this.isPrototype()) {
            return this.prototype.isGenericType();
        }
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    @Override
    public boolean isHierarchyConnected() {
        if (!this.isPrototype()) {
            return this.prototype.isHierarchyConnected();
        }
        return (this.tagBits & 0x6000000L) == 0L;
    }

    @Override
    public boolean isRepeatableAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        return this.containerAnnotationType != null;
    }

    @Override
    public int kind() {
        if (!this.isPrototype()) {
            return this.prototype.kind();
        }
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        if (!this.isPrototype()) {
            int memberTypesLength;
            if ((this.tagBits & 0x10000000L) == 0L) {
                return this.memberTypes;
            }
            ReferenceBinding[] members = this.prototype.memberTypes();
            int n = memberTypesLength = members == null ? 0 : members.length;
            if (memberTypesLength > 0) {
                this.memberTypes = new ReferenceBinding[memberTypesLength];
                int i = 0;
                while (i < memberTypesLength) {
                    this.memberTypes[i] = this.environment.createMemberType(members[i], this);
                    ++i;
                }
            }
            this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
            return this.memberTypes;
        }
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int i = this.memberTypes.length;
        while (--i >= 0) {
            this.memberTypes[i] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.memberTypes[i], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        return this.memberTypes;
    }

    @Override
    public MethodBinding[] methods() {
        if (!this.isPrototype()) {
            this.methods = this.prototype.methods();
            return this.methods;
        }
        if ((this.tagBits & 0x8000L) != 0L) {
            return this.methods;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        int i = this.methods.length;
        while (--i >= 0) {
            this.resolveTypesFor(this.methods[i]);
        }
        this.tagBits |= 0x8000L;
        return this.methods;
    }

    @Override
    public TypeBinding prototype() {
        return this.prototype;
    }

    private boolean isPrototype() {
        return this == this.prototype;
    }

    @Override
    public ReferenceBinding containerAnnotationType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType instanceof UnresolvedReferenceBinding) {
            this.containerAnnotationType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.containerAnnotationType, this.environment, false);
        }
        return this.containerAnnotationType;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        TypeBinding resolvedType;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypeFor(field);
        }
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        field.type = resolvedType = BinaryTypeBinding.resolveType(field.type, this.environment, true);
        if ((resolvedType.tagBits & 0x80L) != 0L) {
            field.tagBits |= 0x80L;
        }
        field.modifiers &= 0xFDFFFFFF;
        return field;
    }

    MethodBinding resolveTypesFor(MethodBinding method) {
        TypeBinding resolvedType;
        if (!this.isPrototype()) {
            return this.prototype.resolveTypesFor(method);
        }
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (!method.isConstructor()) {
            TypeBinding resolvedType2;
            method.returnType = resolvedType2 = BinaryTypeBinding.resolveType(method.returnType, this.environment, true);
            if ((resolvedType2.tagBits & 0x80L) != 0L) {
                method.tagBits |= 0x80L;
            }
        }
        int i = method.parameters.length;
        while (--i >= 0) {
            method.parameters[i] = resolvedType = BinaryTypeBinding.resolveType(method.parameters[i], this.environment, true);
            if ((resolvedType.tagBits & 0x80L) == 0L) continue;
            method.tagBits |= 0x80L;
        }
        i = method.thrownExceptions.length;
        while (--i >= 0) {
            resolvedType = (ReferenceBinding)BinaryTypeBinding.resolveType(method.thrownExceptions[i], this.environment, true);
            method.thrownExceptions[i] = resolvedType;
            if ((((ReferenceBinding)resolvedType).tagBits & 0x80L) == 0L) continue;
            method.tagBits |= 0x80L;
        }
        i = method.typeVariables.length;
        while (--i >= 0) {
            method.typeVariables[i].resolve();
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    @Override
    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        if (!this.isPrototype()) {
            return this.prototype.retrieveAnnotations(binding);
        }
        return AnnotationBinding.addStandardAnnotations(super.retrieveAnnotations(binding), binding.getAnnotationTagBits(), this.environment);
    }

    @Override
    public void setContainerAnnotationType(ReferenceBinding value) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        this.containerAnnotationType = value;
    }

    @Override
    public void tagAsHavingDefectiveContainerType() {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.containerAnnotationType != null && this.containerAnnotationType.isValidBinding()) {
            this.containerAnnotationType = new ProblemReferenceBinding(this.containerAnnotationType.compoundName, this.containerAnnotationType, 22);
        }
    }

    @Override
    SimpleLookupTable storedAnnotations(boolean forceInitialize) {
        if (!this.isPrototype()) {
            return this.prototype.storedAnnotations(forceInitialize);
        }
        if (forceInitialize && this.storedAnnotations == null) {
            if (!this.environment.globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    private void scanFieldForNullAnnotation(IBinaryField field, FieldBinding fieldBinding, boolean isEnum, ITypeAnnotationWalker externalAnnotationWalker) {
        IBinaryAnnotation[] annotations;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (isEnum && (field.getModifiers() & 0x4000) != 0) {
            fieldBinding.tagBits |= 0x100000000000000L;
            return;
        }
        if (!CharOperation.equals(this.fPackage.compoundName, TypeConstants.JAVA_LANG_ANNOTATION) && this.environment.usesNullTypeAnnotations()) {
            TypeBinding fieldType = fieldBinding.type;
            if (fieldType != null && !fieldType.isBaseType() && (fieldType.tagBits & 0x180000000000000L) == 0L && fieldType.acceptsNonNullDefault() && this.hasNonNullDefaultFor(32, true)) {
                fieldBinding.type = this.environment.createAnnotatedType(fieldType, new AnnotationBinding[]{this.environment.getNonNullAnnotation()});
            }
            return;
        }
        if (fieldBinding.type == null || fieldBinding.type.isBaseType()) {
            return;
        }
        boolean explicitNullness = false;
        IBinaryAnnotation[] iBinaryAnnotationArray = annotations = externalAnnotationWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER ? externalAnnotationWalker.getAnnotationsAtCursor(fieldBinding.type.id) : field.getAnnotations();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.length) {
                char[] annotationTypeName = annotations[i].getTypeName();
                if (annotationTypeName[0] == 'L') {
                    int typeBit = this.environment.getNullAnnotationBit(this.signature2qualifiedTypeName(annotationTypeName));
                    if (typeBit == 32) {
                        fieldBinding.tagBits |= 0x100000000000000L;
                        explicitNullness = true;
                        break;
                    }
                    if (typeBit == 64) {
                        fieldBinding.tagBits |= 0x80000000000000L;
                        explicitNullness = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (explicitNullness && this.externalAnnotationStatus.isPotentiallyUnannotatedLib()) {
            this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
        }
        if (!explicitNullness && (this.tagBits & 0x200000000000000L) != 0L) {
            fieldBinding.tagBits |= 0x100000000000000L;
        }
    }

    private void scanMethodForNullAnnotation(IBinaryMethod method, MethodBinding methodBinding, ITypeAnnotationWalker externalAnnotationWalker, boolean useNullTypeAnnotations) {
        int numParamAnnotations;
        ITypeAnnotationWalker returnWalker;
        IBinaryAnnotation[] annotations;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        if (this.isEnum()) {
            int purpose = 0;
            if (CharOperation.equals(TypeConstants.VALUEOF, method.getSelector()) && methodBinding.parameters.length == 1 && methodBinding.parameters[0].id == 11) {
                purpose = 10;
            } else if (CharOperation.equals(TypeConstants.VALUES, method.getSelector()) && methodBinding.parameters == Binding.NO_PARAMETERS) {
                purpose = 9;
            }
            if (purpose != 0) {
                boolean needToDefer;
                boolean bl = needToDefer = this.environment.globalOptions.useNullTypeAnnotations == null;
                if (needToDefer) {
                    this.environment.deferredEnumMethods.add(methodBinding);
                } else {
                    SyntheticMethodBinding.markNonNull(methodBinding, purpose, this.environment);
                }
                return;
            }
        }
        IBinaryAnnotation[] iBinaryAnnotationArray = annotations = (returnWalker = externalAnnotationWalker.toMethodReturn()) != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER ? returnWalker.getAnnotationsAtCursor(methodBinding.returnType.id) : method.getAnnotations();
        if (annotations != null) {
            int i = 0;
            while (i < annotations.length) {
                char[] annotationTypeName = annotations[i].getTypeName();
                if (annotationTypeName[0] == 'L') {
                    int typeBit = this.environment.getNullAnnotationBit(this.signature2qualifiedTypeName(annotationTypeName));
                    if (typeBit == 128) {
                        methodBinding.defaultNullness = this.getNonNullByDefaultValue(annotations[i]);
                        if (methodBinding.defaultNullness == 2) {
                            methodBinding.tagBits |= 0x400000000000000L;
                        } else if (methodBinding.defaultNullness != 0) {
                            methodBinding.tagBits |= 0x200000000000000L;
                            if (methodBinding.defaultNullness == 1 && this.environment.usesNullTypeAnnotations()) {
                                methodBinding.defaultNullness |= 0x18;
                            }
                        }
                    } else if (typeBit == 32) {
                        methodBinding.tagBits |= 0x100000000000000L;
                    } else if (typeBit == 64) {
                        methodBinding.tagBits |= 0x80000000000000L;
                    }
                }
                ++i;
            }
        }
        TypeBinding[] parameters = methodBinding.parameters;
        int numVisibleParams = parameters.length;
        int n = numParamAnnotations = externalAnnotationWalker instanceof ExternalAnnotationProvider.IMethodAnnotationWalker ? ((ExternalAnnotationProvider.IMethodAnnotationWalker)externalAnnotationWalker).getParameterCount() : method.getAnnotatedParametersCount();
        if (numParamAnnotations > 0) {
            int j = 0;
            while (j < numVisibleParams) {
                if (numParamAnnotations > 0) {
                    IBinaryAnnotation[] paramAnnotations;
                    int startIndex = numParamAnnotations - numVisibleParams;
                    ITypeAnnotationWalker parameterWalker = externalAnnotationWalker.toMethodParameter((short)(j + startIndex));
                    IBinaryAnnotation[] iBinaryAnnotationArray2 = paramAnnotations = parameterWalker != ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER ? parameterWalker.getAnnotationsAtCursor(parameters[j].id) : method.getParameterAnnotations(j + startIndex, this.fileName);
                    if (paramAnnotations != null) {
                        int i = 0;
                        while (i < paramAnnotations.length) {
                            char[] annotationTypeName = paramAnnotations[i].getTypeName();
                            if (annotationTypeName[0] == 'L') {
                                int typeBit = this.environment.getNullAnnotationBit(this.signature2qualifiedTypeName(annotationTypeName));
                                if (typeBit == 32) {
                                    if (methodBinding.parameterNonNullness == null) {
                                        methodBinding.parameterNonNullness = new Boolean[numVisibleParams];
                                    }
                                    methodBinding.parameterNonNullness[j] = Boolean.TRUE;
                                    break;
                                }
                                if (typeBit == 64) {
                                    if (methodBinding.parameterNonNullness == null) {
                                        methodBinding.parameterNonNullness = new Boolean[numVisibleParams];
                                    }
                                    methodBinding.parameterNonNullness[j] = Boolean.FALSE;
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
        }
        if (useNullTypeAnnotations && this.externalAnnotationStatus.isPotentiallyUnannotatedLib()) {
            if (methodBinding.returnType.hasNullTypeAnnotations()) {
                this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
            } else {
                TypeBinding[] typeBindingArray = parameters;
                int n2 = parameters.length;
                int n3 = 0;
                while (n3 < n2) {
                    TypeBinding parameter = typeBindingArray[n3];
                    if (parameter.hasNullTypeAnnotations()) {
                        this.externalAnnotationStatus = ExternalAnnotationStatus.TYPE_IS_ANNOTATED;
                        break;
                    }
                    ++n3;
                }
            }
        }
    }

    private void scanTypeForNullDefaultAnnotation(IBinaryType binaryType, PackageBinding packageBinding) {
        ReferenceBinding packageInfo;
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        char[][] nonNullByDefaultAnnotationName = this.environment.getNonNullByDefaultAnnotationName();
        if (nonNullByDefaultAnnotationName == null) {
            return;
        }
        if (CharOperation.equals(CharOperation.splitOn('/', binaryType.getName()), nonNullByDefaultAnnotationName)) {
            return;
        }
        IBinaryAnnotation[] annotations = binaryType.getAnnotations();
        boolean isPackageInfo = CharOperation.equals(this.sourceName(), TypeConstants.PACKAGE_INFO_NAME);
        if (annotations != null) {
            long annotationBit = 0L;
            int nullness = 0;
            int length = annotations.length;
            int i = 0;
            while (i < length) {
                int typeBit;
                char[] annotationTypeName = annotations[i].getTypeName();
                if (annotationTypeName[0] == 'L' && (typeBit = this.environment.getNullAnnotationBit(this.signature2qualifiedTypeName(annotationTypeName))) == 128) {
                    nullness = this.getNonNullByDefaultValue(annotations[i]);
                    if (nullness == 2) {
                        annotationBit = 0x400000000000000L;
                    } else if (nullness != 0) {
                        annotationBit = 0x200000000000000L;
                        if (nullness == 1 && this.environment.usesNullTypeAnnotations()) {
                            nullness |= 0x38;
                        }
                    }
                    this.defaultNullness = nullness;
                    break;
                }
                ++i;
            }
            if (annotationBit != 0L) {
                this.tagBits |= annotationBit;
                if (isPackageInfo) {
                    packageBinding.defaultNullness = nullness;
                }
                return;
            }
        }
        if (isPackageInfo) {
            packageBinding.defaultNullness = 0;
            return;
        }
        ReferenceBinding enclosingTypeBinding = this.enclosingType;
        if (enclosingTypeBinding != null && this.setNullDefault(enclosingTypeBinding.tagBits, enclosingTypeBinding.getNullDefault())) {
            return;
        }
        if (packageBinding.defaultNullness == 0 && !isPackageInfo && (packageInfo = packageBinding.getType(TypeConstants.PACKAGE_INFO_NAME)) == null) {
            packageBinding.defaultNullness = 0;
        }
        this.setNullDefault(0L, packageBinding.defaultNullness);
    }

    boolean setNullDefault(long oldNullTagBits, int newNullDefault) {
        this.defaultNullness = newNullDefault;
        if (newNullDefault != 0) {
            this.tagBits = newNullDefault == 2 ? (this.tagBits |= 0x400000000000000L) : (this.tagBits |= 0x200000000000000L);
            return true;
        }
        if ((oldNullTagBits & 0x200000000000000L) != 0L) {
            this.tagBits |= 0x200000000000000L;
            return true;
        }
        if ((oldNullTagBits & 0x400000000000000L) != 0L) {
            this.tagBits |= 0x400000000000000L;
            return true;
        }
        return false;
    }

    int getNonNullByDefaultValue(IBinaryAnnotation annotation) {
        char[] annotationTypeName = annotation.getTypeName();
        char[][] typeName = this.signature2qualifiedTypeName(annotationTypeName);
        IBinaryElementValuePair[] elementValuePairs = annotation.getElementValuePairs();
        if (elementValuePairs == null || elementValuePairs.length == 0) {
            MethodBinding[] annotationMethods;
            ReferenceBinding annotationType = this.environment.getType(typeName);
            if (annotationType == null) {
                return 0;
            }
            if (annotationType.isUnresolvedType()) {
                annotationType = ((UnresolvedReferenceBinding)annotationType).resolve(this.environment, false);
            }
            if ((annotationMethods = annotationType.methods()) != null && annotationMethods.length == 1) {
                Object value = annotationMethods[0].getDefaultValue();
                return Annotation.nullLocationBitsFromAnnotationValue(value);
            }
            return 1;
        }
        if (elementValuePairs.length > 0) {
            int nullness = 0;
            int i = 0;
            while (i < elementValuePairs.length) {
                nullness |= Annotation.nullLocationBitsFromAnnotationValue(elementValuePairs[i].getValue());
                ++i;
            }
            return nullness;
        }
        return 2;
    }

    private char[][] signature2qualifiedTypeName(char[] typeSignature) {
        return CharOperation.splitOn('/', typeSignature, 1, typeSignature.length - 1);
    }

    @Override
    int getNullDefault() {
        return this.defaultNullness;
    }

    private void scanTypeForContainerAnnotation(IBinaryType binaryType, char[][][] missingTypeNames) {
        if (!this.isPrototype()) {
            throw new IllegalStateException();
        }
        IBinaryAnnotation[] annotations = binaryType.getAnnotations();
        if (annotations != null) {
            int length = annotations.length;
            int i = 0;
            while (i < length) {
                char[] annotationTypeName = annotations[i].getTypeName();
                if (CharOperation.equals(annotationTypeName, ConstantPool.JAVA_LANG_ANNOTATION_REPEATABLE)) {
                    Object value;
                    IBinaryElementValuePair[] elementValuePairs = annotations[i].getElementValuePairs();
                    if (elementValuePairs == null || elementValuePairs.length != 1 || !((value = elementValuePairs[0].getValue()) instanceof ClassSignature)) break;
                    this.containerAnnotationType = (ReferenceBinding)this.environment.getTypeFromSignature(((ClassSignature)value).getTypeName(), 0, -1, false, null, missingTypeNames, ITypeAnnotationWalker.EMPTY_ANNOTATION_WALKER);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public ReferenceBinding superclass() {
        if (!this.isPrototype()) {
            this.superclass = this.prototype.superclass();
            return this.superclass;
        }
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        if (this.superclass.problemId() == 1) {
            this.tagBits |= 0x20000L;
        } else {
            boolean wasToleratingMissingTypeProcessingAnnotations = this.environment.mayTolerateMissingType;
            this.environment.mayTolerateMissingType = true;
            try {
                this.superclass.superclass();
                this.superclass.superInterfaces();
            }
            finally {
                this.environment.mayTolerateMissingType = wasToleratingMissingTypeProcessingAnnotations;
            }
        }
        this.typeBits |= this.superclass.typeBits & 0x13;
        if ((this.typeBits & 3) != 0) {
            this.typeBits |= this.applyCloseableClassWhitelists();
        }
        return this.superclass;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (!this.isPrototype()) {
            this.superInterfaces = this.prototype.superInterfaces();
            return this.superInterfaces;
        }
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int i = this.superInterfaces.length;
        while (--i >= 0) {
            this.superInterfaces[i] = (ReferenceBinding)BinaryTypeBinding.resolveType(this.superInterfaces[i], this.environment, true);
            if (this.superInterfaces[i].problemId() == 1) {
                this.tagBits |= 0x20000L;
            } else {
                boolean wasToleratingMissingTypeProcessingAnnotations = this.environment.mayTolerateMissingType;
                this.environment.mayTolerateMissingType = true;
                try {
                    ReferenceBinding superType;
                    this.superInterfaces[i].superclass();
                    if (this.superInterfaces[i].isParameterizedType() && TypeBinding.equalsEquals(superType = this.superInterfaces[i].actualType(), this)) {
                        this.tagBits |= 0x20000L;
                        continue;
                    }
                    this.superInterfaces[i].superInterfaces();
                }
                finally {
                    this.environment.mayTolerateMissingType = wasToleratingMissingTypeProcessingAnnotations;
                }
            }
            this.typeBits |= this.superInterfaces[i].typeBits & 0x13;
            if ((this.typeBits & 3) == 0) continue;
            this.typeBits |= this.applyCloseableInterfaceWhitelists();
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        return this.superInterfaces;
    }

    @Override
    public TypeVariableBinding[] typeVariables() {
        if (!this.isPrototype()) {
            this.typeVariables = this.prototype.typeVariables();
            return this.typeVariables;
        }
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int i = this.typeVariables.length;
        while (--i >= 0) {
            this.typeVariables[i].resolve();
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int length;
        int i;
        if (this.hasTypeAnnotations()) {
            return this.annotatedDebugName();
        }
        StringBuffer buffer = new StringBuffer();
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isProtected()) {
            buffer.append("protected ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isFinal()) {
            buffer.append("final ");
        }
        if (this.isEnum()) {
            buffer.append("enum ");
        } else if (this.isAnnotationType()) {
            buffer.append("@interface ");
        } else if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            buffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            buffer.append("<");
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.typeVariables[i] == null) {
                    buffer.append("NULL TYPE VARIABLE");
                } else {
                    char[] varChars = this.typeVariables[i].toString().toCharArray();
                    buffer.append(varChars, 1, varChars.length - 2);
                }
                ++i;
            }
            buffer.append(">");
        }
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                buffer.append("\n\timplements : ");
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append(this.fields[i] != null ? "\n" + this.fields[i].toString() : "\nNULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append(this.methods[i] != null ? "\n" + this.methods[i].toString() : "\nNULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append(this.memberTypes[i] != null ? "\n" + this.memberTypes[i].toString() : "\nNULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n\n");
        return buffer.toString();
    }

    @Override
    public TypeBinding unannotated() {
        return this.prototype;
    }

    @Override
    public TypeBinding withoutToplevelNullAnnotation() {
        if (!this.hasNullTypeAnnotations()) {
            return this;
        }
        AnnotationBinding[] newAnnotations = this.environment.filterNullTypeAnnotations(this.typeAnnotations);
        if (newAnnotations.length > 0) {
            return this.environment.createAnnotatedType((TypeBinding)this.prototype, newAnnotations);
        }
        return this.prototype;
    }

    @Override
    MethodBinding[] unResolvedMethods() {
        if (!this.isPrototype()) {
            return this.prototype.unResolvedMethods();
        }
        return this.methods;
    }

    @Override
    public FieldBinding[] unResolvedFields() {
        if (!this.isPrototype()) {
            return this.prototype.unResolvedFields();
        }
        return this.fields;
    }

    public static enum ExternalAnnotationStatus {
        FROM_SOURCE,
        NOT_EEA_CONFIGURED,
        NO_EEA_FILE,
        TYPE_IS_ANNOTATED;


        public boolean isPotentiallyUnannotatedLib() {
            switch (this) {
                case FROM_SOURCE: 
                case TYPE_IS_ANNOTATED: {
                    return false;
                }
            }
            return true;
        }
    }
}

