/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.audit.event.LogEvent;
import org.kie.api.runtime.process.ProcessInstance;

public class RuleFlowLogEvent
extends LogEvent {
    private String processId;
    private String processName;
    private Object processInstanceId;

    public RuleFlowLogEvent(int type, ProcessInstance processInstance) {
        this(type, processInstance.getProcessId(), processInstance.getProcessName(), processInstance.getId());
    }

    public RuleFlowLogEvent(int type, String processId, String processName, Object processInstanceId) {
        super(type);
        this.processId = processId;
        this.processName = processName;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.processId = (String)in.readObject();
        this.processName = (String)in.readObject();
        this.processInstanceId = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.processId);
        out.writeObject(this.processName);
        out.writeObject(this.processInstanceId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public Object getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String toString() {
        String msg = null;
        switch (this.getType()) {
            case 8: {
                msg = "BEFORE RULEFLOW STARTED";
                break;
            }
            case 9: {
                msg = "AFTER RULEFLOW STARTED";
                break;
            }
            case 10: {
                msg = "BEFORE RULEFLOW COMPLETED";
                break;
            }
            case 11: {
                msg = "AFTER RULEFLOW COMPLETED";
            }
        }
        return msg + " process:" + this.processName + "[id=" + this.processId + "]";
    }
}

