/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class UnionCoder
extends StructuredCoder<RawUnionValue> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> elementCoders;

    public static @UnknownKeyFor @NonNull @Initialized UnionCoder of(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> elementCoders) {
        return new UnionCoder(elementCoders);
    }

    private @UnknownKeyFor @NonNull @Initialized int getIndexForEncoding(@UnknownKeyFor @NonNull @Initialized RawUnionValue union) {
        if (union == null) {
            throw new IllegalArgumentException("cannot encode a null tagged union");
        }
        int index = union.getUnionTag();
        if (index < 0 || index >= this.elementCoders.size()) {
            throw new IllegalArgumentException("union value index " + index + " not in range [0.." + (this.elementCoders.size() - 1) + "]");
        }
        return index;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized RawUnionValue union, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(union, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized RawUnionValue union, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        int index = this.getIndexForEncoding(union);
        VarInt.encode(index, outStream);
        Coder<?> coder = this.elementCoders.get(index);
        coder.encode(union.getValue(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RawUnionValue decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RawUnionValue decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        int index = VarInt.decodeInt(inStream);
        Object value = this.elementCoders.get(index).decode(inStream, context);
        return new RawUnionValue(index, value);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Collections.emptyList();
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getComponents() {
        return this.elementCoders;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getElementCoders() {
        return this.elementCoders;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized RawUnionValue union) {
        int index = this.getIndexForEncoding(union);
        Coder<?> coder = this.elementCoders.get(index);
        return coder.isRegisterByteSizeObserverCheap(union.getValue());
    }

    @Override
    public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized RawUnionValue union, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int index = this.getIndexForEncoding(union);
        observer.update(VarInt.getLength(index));
        Coder<?> coder = this.elementCoders.get(index);
        coder.registerByteSizeObserver(union.getValue(), observer);
    }

    private UnionCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> elementCoders) {
        this.elementCoders = elementCoders;
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        UnionCoder.verifyDeterministic(this, "UnionCoder is only deterministic if all element coders are", this.elementCoders);
    }
}

