/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum MemberStatus {
    ACTIVE,
    INVITED,
    MOVED_TO_ANOTHER_TEAM,
    NOT_JOINED,
    REMOVED,
    SUSPENDED,
    OTHER;


    static class Serializer
    extends UnionSerializer<MemberStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MemberStatus value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case ACTIVE: {
                    g.writeString("active");
                    break;
                }
                case INVITED: {
                    g.writeString("invited");
                    break;
                }
                case MOVED_TO_ANOTHER_TEAM: {
                    g.writeString("moved_to_another_team");
                    break;
                }
                case NOT_JOINED: {
                    g.writeString("not_joined");
                    break;
                }
                case REMOVED: {
                    g.writeString("removed");
                    break;
                }
                case SUSPENDED: {
                    g.writeString("suspended");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MemberStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            MemberStatus value = "active".equals(tag) ? ACTIVE : ("invited".equals(tag) ? INVITED : ("moved_to_another_team".equals(tag) ? MOVED_TO_ANOTHER_TEAM : ("not_joined".equals(tag) ? NOT_JOINED : ("removed".equals(tag) ? REMOVED : ("suspended".equals(tag) ? SUSPENDED : OTHER)))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

