/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.util.subscription;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Iterator;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcatenatedPublisher<T>
implements Flow.Publisher<T> {
    private final Iterator<Flow.Publisher<? extends T>> sources;

    public ConcatenatedPublisher(Iterator<Flow.Publisher<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> downstream) {
        ConcatenatedSubscriber<T> subscription = new ConcatenatedSubscriber<T>(downstream, this.sources);
        downstream.onSubscribe(subscription);
        subscription.drain();
    }

    static final class ConcatenatedSubscriber<T>
    extends ConcatenatedSubscription
    implements Flow.Subscriber<T> {
        private final AtomicInteger guardCntr = new AtomicInteger();
        private final Flow.Subscriber<? super T> downstream;
        private final Iterator<Flow.Publisher<? extends T>> sources;
        private long consumed;

        ConcatenatedSubscriber(Flow.Subscriber<? super T> downstream, Iterator<Flow.Publisher<? extends T>> sources) {
            this.downstream = downstream;
            this.sources = sources;
        }

        @Override
        public void onSubscribe(Flow.Subscription s) {
            this.setSubscription(s);
        }

        @Override
        public void onNext(T item) {
            ++this.consumed;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.drain();
        }

        void drain() {
            if (this.guardCntr.getAndIncrement() != 0) {
                return;
            }
            do {
                if (this.isCancelled()) {
                    return;
                }
                if (!this.sources.hasNext()) {
                    this.downstream.onComplete();
                    return;
                }
                long c = this.consumed;
                if (c != 0L) {
                    this.consumed = 0L;
                    this.setProduced(c);
                }
                this.sources.next().subscribe(this);
            } while (this.guardCntr.decrementAndGet() != 0);
        }
    }

    private static class ConcatenatedSubscription
    implements Flow.Subscription {
        private static final VarHandle CURRENT;
        private static final VarHandle NEXT;
        private static final VarHandle DOWNSTREAM_REQUESTED;
        private static final VarHandle PRODUCED;
        private static final VarHandle WIP;
        private Flow.Subscription current;
        private Flow.Subscription next;
        private long requested;
        private long downstreamRequested;
        private long produced;
        private int wip;

        private ConcatenatedSubscription() {
        }

        @Override
        public final void request(long n) {
            long u;
            long r;
            do {
                if ((u = (r = DOWNSTREAM_REQUESTED.getAcquire(this)) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!DOWNSTREAM_REQUESTED.compareAndSet(this, r, u));
            this.arbiterDrain();
        }

        @Override
        public void cancel() {
            Flow.Subscription s = CURRENT.getAndSet(this, this);
            if (s != null && s != this) {
                s.cancel();
            }
            if ((s = NEXT.getAndSet(this, this)) != null && s != this) {
                s.cancel();
            }
        }

        final boolean isCancelled() {
            return CURRENT.getAcquire(this) == this;
        }

        final void setSubscription(Flow.Subscription subscription) {
            if (NEXT.compareAndSet(this, null, subscription)) {
                this.arbiterDrain();
            } else {
                subscription.cancel();
            }
        }

        final void setProduced(long n) {
            PRODUCED.setRelease(this, n);
            this.arbiterDrain();
        }

        private void arbiterDrain() {
            Flow.Subscription requestFrom;
            if (WIP.getAndAdd(this, 1) != 0) {
                return;
            }
            long requestAmount = 0L;
            do {
                Flow.Subscription currentSub;
                if ((currentSub = CURRENT.getAcquire(this)) == this) {
                    return;
                }
                long req = this.requested;
                long downstreamReq = DOWNSTREAM_REQUESTED.getAndSet(this, 0L);
                long prod = PRODUCED.getAndSet(this, 0L);
                Flow.Subscription nextSub = NEXT.getAcquire(this);
                if (nextSub != null && nextSub != this) {
                    NEXT.compareAndSet(this, nextSub, null);
                }
                if (downstreamReq != 0L && (req += downstreamReq) < 0L) {
                    req = Long.MAX_VALUE;
                }
                if (prod != 0L && req != Long.MAX_VALUE) {
                    req -= prod;
                }
                this.requested = req;
                if (nextSub != null && nextSub != this) {
                    requestFrom = nextSub;
                    requestAmount = req;
                    CURRENT.compareAndSet(this, currentSub, nextSub);
                    continue;
                }
                requestFrom = currentSub;
                if ((requestAmount += downstreamReq) >= 0L) continue;
                requestAmount = Long.MAX_VALUE;
            } while (WIP.getAndAdd(this, -1) - 1 != 0);
            if (requestFrom != null && requestAmount != 0L) {
                requestFrom.request(requestAmount);
            }
        }

        static {
            MethodHandles.Lookup lk = MethodHandles.lookup();
            try {
                CURRENT = lk.findVarHandle(ConcatenatedSubscription.class, "current", Flow.Subscription.class);
                NEXT = lk.findVarHandle(ConcatenatedSubscription.class, "next", Flow.Subscription.class);
                DOWNSTREAM_REQUESTED = lk.findVarHandle(ConcatenatedSubscription.class, "downstreamRequested", Long.TYPE);
                PRODUCED = lk.findVarHandle(ConcatenatedSubscription.class, "produced", Long.TYPE);
                WIP = lk.findVarHandle(ConcatenatedSubscription.class, "wip", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new InternalError(ex);
            }
        }
    }
}

