/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.FastTimestamps;

class SnapshotCountDownEvent {
    private static final IgniteLogger LOG = Loggers.forClass(SnapshotCountDownEvent.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z").withZone(ZoneId.systemDefault());
    static final int INIT_SNAPSHOT_OP = 0;
    static final int DO_SNAPSHOT_OP = 1;
    static final int REGISTER_DOWNLOADING_SNAPSHOT_OP = 2;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Deque<State> stateStack = new ArrayDeque<State>();

    SnapshotCountDownEvent() {
    }

    public int incrementAndGet(int state) {
        this.lock.lock();
        try {
            this.stateStack.add(new State(state));
            int n = this.stateStack.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void countDown() {
        this.lock.lock();
        try {
            this.stateStack.pollLast();
            if (this.stateStack.isEmpty()) {
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.stateStack.isEmpty()) {
                if (this.condition.await(30L, TimeUnit.SECONDS)) continue;
                LOG.warn("Failed to wait for all snapshot events: [remaining={}]", new Object[]{this.stateStack});
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String toStringIntState(int state) {
        switch (state) {
            case 0: {
                return "init";
            }
            case 1: {
                return "do";
            }
            case 2: {
                return "register downloading snapshot";
            }
        }
        return "unknown_" + state;
    }

    private static String toStringCoarseTimeMillis(long coarseTimeMillis) {
        return DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(coarseTimeMillis));
    }

    private static final class State {
        private final int state;
        private final long coarseTimeMillis;

        private State(int state, long coarseTimeMillis) {
            this.state = state;
            this.coarseTimeMillis = coarseTimeMillis;
        }

        private State(int state) {
            this(state, FastTimestamps.coarseCurrentTimeMillis());
        }

        public String toString() {
            return "State [state=" + SnapshotCountDownEvent.toStringIntState(this.state) + ", coarseTime=" + SnapshotCountDownEvent.toStringCoarseTimeMillis(this.coarseTimeMillis) + "]";
        }
    }
}

