/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.util.ArrayList;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;
import org.apache.ignite.raft.jraft.util.Requires;

public class AdaptiveBufAllocator {
    private static final int DEFAULT_MINIMUM = 64;
    private static final int DEFAULT_INITIAL = 512;
    private static final int DEFAULT_MAXIMUM = 524288;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    public static final AdaptiveBufAllocator DEFAULT;
    private final int minIndex;
    private final int maxIndex;
    private final int initial;

    private static int getSizeTableIndex(int size) {
        int a;
        int mid;
        int low = 0;
        int high = SIZE_TABLE.length - 1;
        while (true) {
            if (high < low) {
                return low;
            }
            if (high == low) {
                return high;
            }
            mid = low + high >>> 1;
            a = SIZE_TABLE[mid];
            int b = SIZE_TABLE[mid + 1];
            if (size > b) {
                low = mid + 1;
                continue;
            }
            if (size >= a) break;
            high = mid - 1;
        }
        if (size == a) {
            return mid;
        }
        return mid + 1;
    }

    private AdaptiveBufAllocator() {
        this(64, 512, 524288);
    }

    public AdaptiveBufAllocator(int minimum, int initial, int maximum) {
        Requires.requireTrue(minimum > 0, "minimum: " + minimum);
        Requires.requireTrue(initial >= minimum, "initial: " + initial);
        Requires.requireTrue(initial <= maximum, "maximum: " + maximum);
        int minIndex = AdaptiveBufAllocator.getSizeTableIndex(minimum);
        this.minIndex = SIZE_TABLE[minIndex] < minimum ? minIndex + 1 : minIndex;
        int maxIndex = AdaptiveBufAllocator.getSizeTableIndex(maximum);
        this.maxIndex = SIZE_TABLE[maxIndex] > maximum ? maxIndex - 1 : maxIndex;
        this.initial = initial;
    }

    public Handle newHandle() {
        return new HandleImpl(this.minIndex, this.maxIndex, this.initial);
    }

    static {
        int i;
        ArrayList<Integer> sizeTable = new ArrayList<Integer>();
        for (i = 16; i < 512; i += 16) {
            sizeTable.add(i);
        }
        for (i = 512; i > 0; i <<= 1) {
            sizeTable.add(i);
        }
        SIZE_TABLE = new int[sizeTable.size()];
        for (i = 0; i < SIZE_TABLE.length; ++i) {
            AdaptiveBufAllocator.SIZE_TABLE[i] = (Integer)sizeTable.get(i);
        }
        DEFAULT = new AdaptiveBufAllocator();
    }

    private static final class HandleImpl
    implements Handle {
        private final int minIndex;
        private final int maxIndex;
        private int index;
        private int nextAllocateBufSize;
        private boolean decreaseNow;

        HandleImpl(int minIndex, int maxIndex, int initial) {
            this.minIndex = minIndex;
            this.maxIndex = maxIndex;
            this.index = AdaptiveBufAllocator.getSizeTableIndex(initial);
            this.nextAllocateBufSize = SIZE_TABLE[this.index];
        }

        @Override
        public ByteBufferCollector allocate() {
            return ByteBufferCollector.allocate(this.guess());
        }

        @Override
        public ByteBufferCollector allocateByRecyclers() {
            return ByteBufferCollector.allocateByRecyclers(this.guess());
        }

        @Override
        public int guess() {
            return this.nextAllocateBufSize;
        }

        @Override
        public void record(int actualWroteBytes) {
            if (actualWroteBytes <= SIZE_TABLE[Math.max(0, this.index - 1 - 1)]) {
                if (this.decreaseNow) {
                    this.index = Math.max(this.index - 1, this.minIndex);
                    this.nextAllocateBufSize = SIZE_TABLE[this.index];
                    this.decreaseNow = false;
                } else {
                    this.decreaseNow = true;
                }
            } else if (actualWroteBytes >= this.nextAllocateBufSize) {
                this.index = Math.min(this.index + 4, this.maxIndex);
                this.nextAllocateBufSize = SIZE_TABLE[this.index];
                this.decreaseNow = false;
            }
        }
    }

    public static interface Handle {
        public ByteBufferCollector allocate();

        public ByteBufferCollector allocateByRecyclers();

        public int guess();

        public void record(int var1);
    }
}

