/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.Optional;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ImmutableSortRemoveRedundantRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexLiteral;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveRedundantRule
extends RelRule<Config>
implements TransformationRule {
    protected SortRemoveRedundantRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        if (RelOptUtil.isOffset(sort)) {
            return;
        }
        Double inputMaxRowCount = call.getMetadataQuery().getMaxRowCount(sort.getInput());
        Optional<Integer> rowCountThreshold = SortRemoveRedundantRule.getRowCountThreshold(sort);
        if (!rowCountThreshold.isPresent()) {
            return;
        }
        if (inputMaxRowCount != null && inputMaxRowCount <= (double)rowCountThreshold.get().intValue()) {
            call.transformTo(sort.getInput());
        }
    }

    private static Optional<Integer> getRowCountThreshold(Sort sort) {
        if (RelOptUtil.isLimit(sort)) {
            int fetch;
            int n = fetch = sort.fetch instanceof RexLiteral ? RexLiteral.intValue(sort.fetch) : 0;
            if (fetch == 0) {
                return Optional.empty();
            }
            if (RelOptUtil.isOrder(sort)) {
                return Optional.of(1);
            }
            return Optional.of(fetch);
        }
        if (RelOptUtil.isPureOrder(sort)) {
            return Optional.of(1);
        }
        return Optional.empty();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveRedundantRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveRedundantRule toRule() {
            return new SortRemoveRedundantRule(this);
        }
    }
}

