/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.view;

import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.view.AbstractViewConfig;
import io.micronaut.openapi.view.RapiPDFConfig;
import io.micronaut.openapi.view.RapidocConfig;
import io.micronaut.openapi.view.RedocConfig;
import io.micronaut.openapi.view.SwaggerUIConfig;
import io.micronaut.openapi.visitor.ConfigUtils;
import io.micronaut.openapi.visitor.FileUtils;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.group.OpenApiInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class OpenApiViewConfig {
    public static final String RESOURCE_DIR = "res";
    public static final String THEMES_DIR = "theme";
    public static final String TEMPLATES = "templates";
    public static final String TEMPLATES_RAPIPDF = "rapipdf";
    public static final String TEMPLATES_SWAGGER_UI = "swagger-ui";
    public static final String TEMPLATES_REDOC = "redoc";
    public static final String TEMPLATES_RAPIDOC = "rapidoc";
    public static final String SLASH = "/";
    private static final String TEMPLATE_INDEX_HTML = "index.html";
    private static final String REDOC = "redoc";
    private static final String RAPIDOC = "rapidoc";
    private static final String SWAGGER_UI = "swagger-ui";
    private static final String TEMPLATE_OAUTH_2_REDIRECT_HTML = "oauth2-redirect.html";
    private String mappingPath;
    private String title;
    private String specFile;
    private String serverContextPath = "";
    private SwaggerUIConfig swaggerUIConfig;
    private RedocConfig redocConfig;
    private RapidocConfig rapidocConfig;
    private final Map<Pair<String, String>, OpenApiInfo> openApiInfos;

    private OpenApiViewConfig(Map<Pair<String, String>, OpenApiInfo> openApiInfos) {
        this.openApiInfos = openApiInfos;
    }

    private static Map<String, String> parse(String specification) {
        if (specification == null) {
            return Collections.emptyMap();
        }
        return Arrays.stream(specification.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> s.split("=")).filter(keyValue -> ((String[])keyValue).length == 2).peek(keyValue -> {
            keyValue[0] = keyValue[0].trim();
            keyValue[1] = keyValue[1].trim();
        }).filter(keyValue -> !keyValue[0].isEmpty() && !keyValue[1].isEmpty()).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
    }

    public static OpenApiViewConfig fromSpecification(String specification, Map<Pair<String, String>, OpenApiInfo> openApiInfos, Properties openApiProperties, VisitorContext context) {
        HashMap<String, String> openApiMap = new HashMap<String, String>(openApiProperties.size());
        openApiProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> openApiMap.put((String)key, (String)value)));
        openApiMap.putAll(OpenApiViewConfig.parse(specification));
        OpenApiViewConfig cfg = new OpenApiViewConfig(openApiInfos);
        RapiPDFConfig rapiPDFConfig = RapiPDFConfig.fromProperties(openApiMap, openApiInfos, context);
        if ("true".equals(openApiMap.getOrDefault("redoc.enabled", Boolean.FALSE.toString()))) {
            cfg.redocConfig = RedocConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.redocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("rapidoc.enabled", Boolean.FALSE.toString()))) {
            cfg.rapidocConfig = RapidocConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.rapidocConfig.rapiPDFConfig = rapiPDFConfig;
        }
        if ("true".equals(openApiMap.getOrDefault("swagger-ui.enabled", Boolean.FALSE.toString()))) {
            cfg.swaggerUIConfig = SwaggerUIConfig.fromProperties(openApiMap, openApiInfos, context);
            cfg.swaggerUIConfig.rapiPDFConfig = rapiPDFConfig;
        }
        cfg.mappingPath = openApiMap.getOrDefault("mapping.path", "swagger");
        return cfg;
    }

    public boolean isEnabled() {
        return this.redocConfig != null || this.rapidocConfig != null || this.swaggerUIConfig != null;
    }

    public void render(Path outputDir, VisitorContext context) throws IOException {
        if (this.redocConfig != null) {
            Path redocDir = outputDir.resolve("redoc");
            this.render(this.redocConfig, redocDir, "templates/redoc/index.html", context);
            this.copyResources(this.redocConfig, redocDir, "redoc", this.redocConfig.getResources(), context);
            if (this.redocConfig.rapiPDFConfig.enabled) {
                this.copyResources(this.redocConfig.rapiPDFConfig, redocDir, TEMPLATES_RAPIPDF, this.redocConfig.rapiPDFConfig.getResources(), context);
            }
        }
        if (this.rapidocConfig != null) {
            Path rapidocDir = outputDir.resolve("rapidoc");
            this.render(this.rapidocConfig, rapidocDir, "templates/rapidoc/index.html", context);
            this.copyResources(this.rapidocConfig, rapidocDir, "rapidoc", this.rapidocConfig.getResources(), context);
            if (this.rapidocConfig.rapiPDFConfig.enabled) {
                this.copyResources(this.rapidocConfig.rapiPDFConfig, rapidocDir, TEMPLATES_RAPIPDF, this.rapidocConfig.rapiPDFConfig.getResources(), context);
            }
        }
        if (this.swaggerUIConfig != null) {
            Path swaggerUiDir = outputDir.resolve("swagger-ui");
            this.render(this.swaggerUIConfig, swaggerUiDir, "templates/swagger-ui/index.html", context);
            if (SwaggerUIConfig.hasOauth2Option(this.swaggerUIConfig.options)) {
                this.render(this.swaggerUIConfig, swaggerUiDir, "templates/swagger-ui/oauth2-redirect.html", context);
            }
            this.copyResources(this.swaggerUIConfig, swaggerUiDir, "swagger-ui", this.swaggerUIConfig.getResources(), context);
            if (this.swaggerUIConfig.rapiPDFConfig.enabled) {
                this.copyResources(this.swaggerUIConfig.rapiPDFConfig, swaggerUiDir, TEMPLATES_RAPIPDF, this.swaggerUIConfig.rapiPDFConfig.getResources(), context);
            }
            this.copySwaggerUiTheme(this.swaggerUIConfig, swaggerUiDir, "swagger-ui", context);
        }
    }

    private void copySwaggerUiTheme(SwaggerUIConfig cfg, Path outputDir, String templatesDir, VisitorContext context) throws IOException {
        if (!cfg.copyTheme) {
            return;
        }
        String themeFileName = cfg.theme.getCss() + ".css";
        Path resDir = outputDir.resolve(RESOURCE_DIR);
        if (!Files.exists(resDir, new LinkOption[0])) {
            Files.createDirectories(resDir, new FileAttribute[0]);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            InputStream is = classLoader.getResourceAsStream("templates/" + templatesDir + SLASH + THEMES_DIR + SLASH + themeFileName);
            Files.copy(is, Paths.get(resDir.toString(), themeFileName), StandardCopyOption.REPLACE_EXISTING);
            Path file = resDir.resolve(themeFileName);
            if (context != null) {
                context.info("Writing OpenAPI View Resources to destination: " + file);
                context.getClassesOutputPath().ifPresent(path -> context.addGeneratedResource(path.relativize(file).toString()));
            }
        }
        catch (Exception e) {
            if (context != null) {
                context.warn("Can't copy resource: " + themeFileName, null);
            }
            throw new RuntimeException(e);
        }
    }

    private void copyResources(AbstractViewConfig cfg, Path outputDir, String templateDir, List<String> resources, VisitorContext context) throws IOException {
        if (!cfg.copyResources) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        Path outputResDir = outputDir.resolve(RESOURCE_DIR);
        if (!Files.exists(outputResDir, new LinkOption[0])) {
            Files.createDirectories(outputResDir, new FileAttribute[0]);
        }
        if (CollectionUtils.isNotEmpty(resources)) {
            for (String resource : resources) {
                try {
                    InputStream is = classLoader.getResourceAsStream("templates/" + templateDir + SLASH + resource);
                    Files.copy(is, Paths.get(outputDir.toString(), resource), StandardCopyOption.REPLACE_EXISTING);
                    Path file = outputResDir.resolve(resource);
                    if (context == null) continue;
                    context.info("Writing OpenAPI View Resources to destination: " + file);
                    context.getClassesOutputPath().ifPresent(path -> context.addGeneratedResource(path.relativize(file).toString()));
                }
                catch (Exception e) {
                    if (context != null) {
                        context.warn("Can't copy resource: " + resource, null);
                    }
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readTemplateFromClasspath(String templateName) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(templateName);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                string = this.readFile(reader);
            }
            return string;
        }
        catch (Exception e) {
            throw new IOException("Fail to load " + templateName, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String readTemplateFromCustomPath(String customPathStr, VisitorContext context) throws IOException {
        String projectDir = "";
        Path projectPath = ConfigUtils.getProjectPath(context);
        if (projectPath != null) {
            projectDir = projectPath.toString().replaceAll("\\\\", SLASH);
        }
        if (customPathStr.startsWith("project:")) {
            customPathStr = customPathStr.replace("project:", projectDir);
        } else if (!customPathStr.startsWith("file:") && !customPathStr.startsWith("classpath:")) {
            if (!projectDir.endsWith(SLASH)) {
                projectDir = projectDir + SLASH;
            }
            if (customPathStr.startsWith(SLASH)) {
                customPathStr = customPathStr.substring(1);
            }
            customPathStr = projectDir + customPathStr;
        } else if (customPathStr.startsWith("file:")) {
            customPathStr = customPathStr.substring(5);
        } else if (customPathStr.startsWith("classpath:")) {
            DefaultClassPathResourceLoader resourceLoader = new DefaultClassPathResourceLoader(this.getClass().getClassLoader());
            Optional inOpt = resourceLoader.getResourceAsStream(customPathStr);
            if (!inOpt.isPresent()) {
                throw new IOException("Fail to load " + customPathStr);
            }
            try (InputStream in = (InputStream)inOpt.get();){
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    string = this.readFile(reader);
                }
                return string;
            }
            catch (IOException e) {
                throw new IOException("Fail to load " + customPathStr, e);
            }
        }
        Path templatePath = FileUtils.resolve(context, Paths.get(customPathStr, new String[0]));
        if (!Files.isReadable(templatePath)) {
            throw new IOException("Can't read file " + customPathStr);
        }
        try (BufferedReader reader = Files.newBufferedReader(templatePath);){
            String string = this.readFile(reader);
            return string;
        }
        catch (IOException e) {
            throw new IOException("Fail to load " + customPathStr, e);
        }
    }

    private String readFile(BufferedReader reader) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder(1024);
        while ((line = reader.readLine()) != null) {
            buf.append(line).append('\n');
        }
        return buf.toString();
    }

    private void render(AbstractViewConfig cfg, Path outputDir, String templateName, VisitorContext context) throws IOException {
        String template = StringUtils.isEmpty((CharSequence)cfg.templatePath) ? this.readTemplateFromClasspath(templateName) : this.readTemplateFromCustomPath(cfg.templatePath, context);
        template = cfg.render(template, context);
        template = OpenApiViewConfig.replacePlaceHolder(template, "specURL", this.getSpecURL(cfg, context), "");
        template = OpenApiViewConfig.replacePlaceHolder(template, "title", this.getTitle(), "");
        if (!Files.exists(outputDir, new LinkOption[0])) {
            Files.createDirectories(outputDir, new FileAttribute[0]);
        }
        String fileName = templateName.substring(templateName.lastIndexOf(SLASH) + 1);
        Path file = outputDir.resolve(fileName);
        if (context != null) {
            context.info("Writing OpenAPI View to destination: " + file);
            context.getClassesOutputPath().ifPresent(path -> context.addGeneratedResource(path.relativize(file).toString()));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(template);
        }
    }

    public void setServerContextPath(String contextPath) {
        this.serverContextPath = contextPath == null ? "" : contextPath;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSpecURL(AbstractViewConfig cfg, VisitorContext context) {
        if (cfg.specUrl != null) {
            return cfg.specUrl;
        }
        String specUrl = StringUtils.prependUri((String)this.serverContextPath, (String)StringUtils.prependUri((String)this.mappingPath, (String)this.specFile));
        if (StringUtils.isEmpty((CharSequence)this.serverContextPath)) {
            String contextPath = ConfigUtils.getConfigProperty("micronaut.server.context-path", context);
            if (contextPath == null) {
                contextPath = "";
            }
            if (!contextPath.startsWith(SLASH) && !contextPath.startsWith("$")) {
                contextPath = SLASH + contextPath;
            }
            if (!contextPath.endsWith(SLASH)) {
                contextPath = contextPath + SLASH;
            }
            if (specUrl.startsWith(SLASH)) {
                specUrl = specUrl.substring(1);
            }
            specUrl = contextPath + specUrl;
        }
        return specUrl;
    }

    public void setSpecFile(String specFile) {
        this.specFile = specFile;
    }

    static String replacePlaceHolder(String template, String placeHolder, String value, String valuePrefix) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return template.replace("{{" + placeHolder + "}}", "");
        }
        return template.replace("{{" + placeHolder + "}}", valuePrefix + value);
    }

    static enum RendererType {
        SWAGGER_UI("swagger-ui"),
        REDOC("redoc"),
        RAPIDOC("rapidoc");

        private final String templatePath;

        private RendererType(String templatePath) {
            this.templatePath = templatePath;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }
    }
}

