/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;

public class TreeIterator {
    private final ByteBuffer pageBuf;
    private final int pageSize;

    public TreeIterator(int size) {
        this.pageSize = size;
        this.pageBuf = ByteBuffer.allocateDirect(this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L, T extends L> void iterate(BPlusTree<L, T> tree, PageMemoryEx pageMemory, BPlusTree.TreeRowClosure<L, T> c) throws IgniteCheckedException {
        int grpId = tree.groupId();
        long leafId = this.findFirstLeafId(grpId, tree.getMetaPageId(), pageMemory);
        long bufAddr = GridUnsafe.bufferAddress(this.pageBuf);
        while (leafId != 0L) {
            Object io;
            long leafPage = pageMemory.acquirePage(grpId, leafId);
            try {
                long leafPageAddr = pageMemory.readLock(grpId, leafId, leafPage);
                try {
                    io = PageIO.getBPlusIO(leafPageAddr);
                    assert (io instanceof BPlusLeafIO) : io;
                    GridUnsafe.copyMemory(leafPageAddr, bufAddr, this.pageSize);
                }
                finally {
                    pageMemory.readUnlock(grpId, leafId, leafPage);
                }
            }
            finally {
                pageMemory.releasePage(grpId, leafId, leafPage);
            }
            int cnt = ((BPlusIO)io).getCount(bufAddr);
            for (int idx = 0; idx < cnt; ++idx) {
                c.apply(tree, (BPlusIO<L>)io, bufAddr, idx);
            }
            leafId = ((BPlusIO)io).getForward(bufAddr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findFirstLeafId(int grpId, long metaPageId, PageMemoryEx partPageMemory) throws IgniteCheckedException {
        long metaPage = partPageMemory.acquirePage(grpId, metaPageId);
        try {
            long l;
            long metaPageAddr = partPageMemory.readLock(grpId, metaPageId, metaPage);
            try {
                BPlusMetaIO metaIO = (BPlusMetaIO)PageIO.getPageIO(metaPageAddr);
                l = metaIO.getFirstPageId(metaPageAddr, 0);
            }
            catch (Throwable throwable) {
                partPageMemory.readUnlock(grpId, metaPageId, metaPage);
                throw throwable;
            }
            partPageMemory.readUnlock(grpId, metaPageId, metaPage);
            return l;
        }
        finally {
            partPageMemory.releasePage(grpId, metaPageId, metaPage);
        }
    }
}

