/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryFetchResult
extends JdbcResult {
    private List<List<Object>> items;
    private boolean last;

    JdbcQueryFetchResult() {
        super((byte)3);
    }

    JdbcQueryFetchResult(List<List<Object>> items, boolean last) {
        super((byte)3);
        this.items = items;
        this.last = last;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeBoolean(this.last);
        JdbcUtils.writeItems(writer, this.items, protoCtx);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.last = reader.readBoolean();
        this.items = JdbcUtils.readItems(reader, protoCtx);
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryFetchResult.class, this);
    }
}

