/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.persistence.utils.pubsub;

import java.util.concurrent.Flow;

public abstract class BasicProcessor<S, T>
implements Flow.Processor<S, T> {
    protected Flow.Subscriber<? super T> subscriber;
    protected Flow.Subscription subscription;

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("Only one subscriber is supported");
        }
        this.subscriber = subscriber;
        if (this.subscription != null) {
            this.subscriber.onSubscribe(this.subscription);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription != null) {
            throw new IllegalStateException("Only one subscription is supported. Cannot subscribe to multiple subscribers");
        }
        this.subscription = subscription;
        if (this.subscriber != null) {
            this.subscriber.onSubscribe(subscription);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }
}

