/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.logger;

import java.io.PrintWriter;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.jetbrains.annotations.Nullable;

class HttpLogging {
    private final ApiClient client;
    @Nullable
    private HttpLoggingInterceptor interceptor;

    HttpLogging(ApiClient client) {
        this.client = client;
    }

    void startHttpLogging(PrintWriter output, boolean[] verbose) {
        if (this.interceptor == null) {
            OkHttpClient.Builder builder = this.client.getHttpClient().newBuilder();
            this.interceptor = new HttpLoggingInterceptor(output::println);
            this.interceptor.setLevel(HttpLogging.verbosityLevel(verbose));
            builder.interceptors().add(this.interceptor);
            this.client.setHttpClient(builder.build());
        }
    }

    private static HttpLoggingInterceptor.Level verbosityLevel(boolean[] verbose) {
        if (verbose.length > 2) {
            return HttpLoggingInterceptor.Level.BODY;
        }
        if (verbose.length > 1) {
            return HttpLoggingInterceptor.Level.HEADERS;
        }
        return HttpLoggingInterceptor.Level.BASIC;
    }

    void stopHttpLogging() {
        if (this.interceptor != null) {
            OkHttpClient.Builder builder = this.client.getHttpClient().newBuilder();
            builder.interceptors().remove(this.interceptor);
            this.client.setHttpClient(builder.build());
            this.interceptor = null;
        }
    }
}

