/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.pruning;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite3.internal.sql.engine.externalize.RelJsonReader;
import org.apache.ignite3.internal.sql.engine.externalize.RelJsonWriter;
import org.apache.ignite3.internal.sql.engine.prepare.pruning.PartitionPruningMetadataExtractor;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataInput;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataOutput;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;
import org.jetbrains.annotations.TestOnly;

public class PartitionPruningColumns
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final List<Int2ObjectMap<RexNode>> columns;

    public PartitionPruningColumns(List<Int2ObjectMap<RexNode>> columns) {
        this.columns = Collections.unmodifiableList(columns);
    }

    public List<Int2ObjectMap<RexNode>> columns() {
        return this.columns;
    }

    public boolean containCorrelatedVariables() {
        return this.columns.stream().anyMatch(c -> c.values().stream().anyMatch(PartitionPruningMetadataExtractor::isCorrelatedVariable));
    }

    public String toString() {
        return S.toString(PartitionPruningColumns.class, this, "columns", this.columns);
    }

    private SerializedForm writeReplace() {
        return new SerializedForm(this);
    }

    @TestOnly
    public static List<List<Map.Entry<Integer, RexNode>>> canonicalForm(PartitionPruningColumns columns) {
        return columns.columns.stream().map(cols -> cols.int2ObjectEntrySet().stream().map(e -> Map.entry(e.getIntKey(), (RexNode)e.getValue())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private static PartitionPruningColumns readColumns(IgniteDataInput input) throws IOException {
        int numColumnSets = input.readInt();
        ArrayList<Int2ObjectMap<RexNode>> result = new ArrayList<Int2ObjectMap<RexNode>>(numColumnSets);
        for (int i = 0; i < numColumnSets; ++i) {
            PartitionPruningColumns.readExpressions(input, result);
        }
        return new PartitionPruningColumns(result);
    }

    private static void readExpressions(IgniteDataInput input, List<Int2ObjectMap<RexNode>> output) throws IOException {
        int numColumns = input.readInt();
        Int2ObjectOpenHashMap expr = new Int2ObjectOpenHashMap(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            int key = input.readInt();
            String exprJson = input.readUTF();
            RexNode rexNode = RelJsonReader.fromExprJson(exprJson);
            expr.put(key, (Object)rexNode);
        }
        output.add((Int2ObjectMap<RexNode>)expr);
    }

    static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] bytes;

        private SerializedForm(PartitionPruningColumns columns) {
            try (IgniteUnsafeDataOutput output = new IgniteUnsafeDataOutput(256);){
                output.writeInt(columns.columns().size());
                for (Int2ObjectMap<RexNode> columnMap : columns.columns()) {
                    output.writeInt(columnMap.size());
                    for (Int2ObjectMap.Entry columnValue : columnMap.int2ObjectEntrySet()) {
                        String exprJson = RelJsonWriter.toExprJson((RexNode)columnValue.getValue());
                        output.writeInt(columnValue.getIntKey());
                        output.writeUTF(exprJson);
                    }
                }
                this.bytes = output.array();
            }
            catch (IOException e) {
                throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unable to serialize partition pruning metadata", (Throwable)e);
            }
        }

        protected final Object readResolve() {
            PartitionPruningColumns partitionPruningColumns;
            IgniteUnsafeDataInput input = new IgniteUnsafeDataInput(this.bytes);
            try {
                partitionPruningColumns = PartitionPruningColumns.readColumns(input);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Unable to deserialize partition pruning metadata", (Throwable)e);
                }
            }
            input.close();
            return partitionPruningColumns;
        }
    }
}

