/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.common;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static List<String> parseMilogKeyListFromKeyAndType(String keyAndType) {
        String[] keyAndTypelist = keyAndType.split(",");
        ArrayList<String> keylist = new ArrayList<String>();
        for (int i = 0; i < keyAndTypelist.length; ++i) {
            String[] split = keyAndTypelist[i].split(":");
            if (split.length <= 0) continue;
            keylist.add(split[0]);
        }
        return keylist;
    }

    public static String parseMilogKeyListStrFromKeyAndType(String keyAndType) {
        String[] keyAndTypelist = keyAndType.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyAndTypelist.length; ++i) {
            String[] split = keyAndTypelist[i].split(":");
            if (i != keyAndTypelist.length - 1 && split.length > 0) {
                sb.append(split[0]).append(",");
                continue;
            }
            if (i != keyAndTypelist.length - 1 || split.length <= 0) continue;
            sb.append(split[0]);
        }
        return sb.toString();
    }

    public static String parse2KeyAndTypeList(String KeyList, String TypeList) {
        String[] KLSplit = KeyList.split(",");
        String[] TLSplit = TypeList.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < KLSplit.length; ++i) {
            String[] split = KLSplit[i].split(":");
            if (split.length <= 0) continue;
            if (i != KLSplit.length - 1) {
                sb.append(split[0]).append(":").append(TLSplit[i]).append(",");
                continue;
            }
            sb.append(split[0]).append(":").append(TLSplit[i]);
        }
        return sb.toString();
    }

    public static List<String> getKeyListSlice(String keyList) {
        String[] KLSplit = keyList.split(",");
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < KLSplit.length; ++i) {
            String[] split = KLSplit[i].split(":");
            if (split.length <= 1 || split[1].equals("3")) continue;
            ret.add(split[0]);
        }
        return ret;
    }

    public static String createTag(Long spaceId, Long storeId, Long tailId) {
        return "tags_" + spaceId + "_" + storeId + "_" + tailId;
    }

    public static String assembleTopicName(Long appId, String appName) {
        StringBuilder sb = new StringBuilder(appName);
        sb.append("-");
        sb.append(appId);
        sb.append("-");
        sb.append("topic");
        return sb.toString();
    }

    public static String getKeyValueList(String keyList, String valueList) {
        List<String> keyListSlice = Utils.getKeyListSlice(keyList);
        String[] valueS = StringUtils.split((String)valueList, (String)",");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < valueS.length; ++i) {
            try {
                int orderValue = Integer.parseInt(valueS[i]);
                if (orderValue < 0) continue;
                map.put(orderValue, keyListSlice.get(i));
                continue;
            }
            catch (Exception e2) {
                log.error(String.format("Data parsing exception,keyList:%s,valueList:%s", keyList, valueS), (Throwable)e2);
            }
        }
        return map.entrySet().stream().sorted(Comparator.comparing(e -> (Integer)e.getKey())).map(Map.Entry::getValue).collect(Collectors.joining(","));
    }

    public static Map<String, Long> getTodayTime() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        long start = calendar.getTime().getTime();
        map.put("start", start);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(calendar1.get(1), calendar1.get(2), calendar1.get(5), 23, 59, 59);
        long end = calendar1.getTime().getTime();
        map.put("end", end);
        return map;
    }

    public static Integer getRandomNum(Integer right) {
        return ThreadLocalRandom.current().nextInt(right);
    }

    public static List<String> generateCommonTagTopicName(String orgId) {
        return IntStream.range(0, Constant.COMMON_MQ_SUFFIX.size()).mapToObj(value -> {
            String suffix = (String)Constant.COMMON_MQ_SUFFIX.get(value);
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                return String.format("%s_%s_%s", "common_mq_miLog", orgId, suffix);
            }
            return String.format("%s_%s", "common_mq_miLog", suffix);
        }).collect(Collectors.toList());
    }
}

