/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain.analyse;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.domain.analyse.AggrCalcuStrategy;
import org.apache.ozhera.log.manager.model.bo.CalcuAggrParam;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDTO;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataFieldDTO;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;

@Service
public class FieldStrategy
implements AggrCalcuStrategy {
    @Override
    public AggregationBuilder getAggr(CalcuAggrParam param) {
        if (StringUtils.isEmpty((String)param.getBead())) {
            return null;
        }
        TermsAggregationBuilder groupAggBuilder = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_aggs").size(Integer.MAX_VALUE).field(param.getBead())).executionHint("map");
        return groupAggBuilder;
    }

    @Override
    public LogAnalyseDataDTO formatRes(SearchResponse response) {
        ArrayList dataArray = new ArrayList();
        if (Objects.nonNull(response) && Objects.equals(response.status(), RestStatus.OK) && Objects.nonNull(response.getAggregations()) && Objects.nonNull(response.getAggregations().get("group_aggs"))) {
            Terms groupResult = (Terms)response.getAggregations().get("group_aggs");
            for (Terms.Bucket groupBucket : groupResult.getBuckets()) {
                HashMap<String, Object> ferray = new HashMap<String, Object>();
                Object key = groupBucket.getKey();
                long docCount = groupBucket.getDocCount();
                ferray.put("field", key);
                ferray.put("count", docCount);
                dataArray.add(ferray);
            }
        }
        return new LogAnalyseDataFieldDTO(Constant.GSON.toJson(dataArray));
    }
}

