/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.store;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Service;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.mapper.MilogEsIndexMapper;
import org.apache.ozhera.log.manager.model.dto.LogStorageData;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogEsIndexDO;
import org.apache.ozhera.log.manager.service.extension.store.LogStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class DorisLogStorageService
implements LogStorageService {
    private static final Logger log = LoggerFactory.getLogger(DorisLogStorageService.class);
    private static final String ALTER_TABLE_PREFIX = "ALTER TABLE %s ";
    private static final String DROP_COLUMN_FORMAT = "DROP COLUMN %s";
    private static final String ADD_COLUMN_FORMAT = "ADD COLUMN %s %s";
    private static final String CHANGE_COLUMN_FORMAT = "MODIFY COLUMN %s %s";
    private static final String DELETE_TABLE_FORMAT = "DROP TABLE IF EXISTS %s";
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;
    @Resource
    private MilogEsIndexMapper esIndexMapper;

    @Override
    public boolean createTable(LogStorageData storageData) {
        MilogEsClusterDO esClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(storageData.getClusterId());
        if (null == esClusterDO) {
            throw new MilogManageException("doris data config not exist");
        }
        DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + storageData.getClusterId());
        String tableName = this.buildTableName(storageData.getClusterId(), storageData.getStoreId());
        String createTableGrammar = this.buildCreateTableGrammar(tableName, storageData.getKeys(), storageData.getColumnTypes());
        log.info("createTable,tableName:{},sql:{}", (Object)tableName, (Object)createTableGrammar);
        try (Statement statement = dataSource.getConnection().createStatement();){
            statement.execute(createTableGrammar);
        }
        catch (SQLException e) {
            log.error("createTable error,data:{},tableName:{},sql:{}", new Object[]{Constant.GSON.toJson((Object)storageData), tableName, createTableGrammar, e});
            throw new MilogManageException("createTable error:" + e.getMessage());
        }
        this.addLogStorageTable(storageData, tableName);
        return true;
    }

    private void addLogStorageTable(LogStorageData storageData, String tableName) {
        MilogEsIndexDO logStorageData = new MilogEsIndexDO();
        logStorageData.setClusterId(storageData.getClusterId());
        logStorageData.setLogType(storageData.getLogType());
        logStorageData.setIndexName(tableName);
        this.esIndexMapper.insert(logStorageData);
    }

    private String buildCreateTableGrammar(String tableName, String keys, String columnTypes) {
        String CREATE_TABLE_TEMPLATE = "CREATE TABLE %s (%s) DISTRIBUTED BY HASH(`%s`) BUCKETS 1 PROPERTIES\n(\n\"replication_num\" = \"1\"\n);";
        Map<String, String> fieldMap = this.buildFieldMap(keys, columnTypes);
        StringJoiner columnDefinitions = new StringJoiner(", ");
        fieldMap.forEach((key, value) -> columnDefinitions.add(String.format("`%s` %s", key, value)));
        return String.format(CREATE_TABLE_TEMPLATE, tableName, columnDefinitions, "timestamp");
    }

    @Override
    public boolean updateTable(LogStorageData storageData) {
        String tableName = this.buildTableName(storageData.getClusterId(), storageData.getStoreId());
        if (this.noChanges(storageData)) {
            return false;
        }
        DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + storageData.getClusterId());
        try {
            Connection connection = dataSource.getConnection();
            this.deleteColumns(connection, tableName, storageData.getKeys(), storageData.getUpdateKeys());
            this.addColumns(connection, tableName, storageData.getKeys(), storageData.getUpdateKeys(), storageData.getUpdateColumnTypes());
            this.changeColumns(connection, tableName, storageData.getKeys(), storageData.getColumnTypes(), storageData.getUpdateKeys(), storageData.getUpdateColumnTypes());
        }
        catch (Exception e) {
            log.error("updateTable error,data:{}", (Object)Constant.GSON.toJson((Object)storageData), (Object)e);
            throw new MilogManageException("updateTable error:" + e.getMessage());
        }
        this.updateLogStorageTable(storageData, tableName);
        return true;
    }

    private void updateLogStorageTable(LogStorageData storageData, String tableName) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MilogEsIndexDO::getClusterId, (Object)storageData.getClusterId())).eq(MilogEsIndexDO::getIndexName, (Object)tableName);
        List logEsIndexDOS = this.esIndexMapper.selectList((Wrapper)lambdaQueryWrapper);
        for (MilogEsIndexDO logEsIndexDO : logEsIndexDOS) {
            if (Objects.equals(storageData.getLogType(), logEsIndexDO.getLogType())) continue;
            logEsIndexDO.setLogType(storageData.getLogType());
            this.esIndexMapper.updateById(logEsIndexDO);
        }
    }

    private boolean noChanges(LogStorageData storageData) {
        if (StringUtils.isEmpty((CharSequence)storageData.getUpdateKeys()) || StringUtils.isEmpty((CharSequence)storageData.getUpdateColumnTypes())) {
            return true;
        }
        return StringUtils.equals((CharSequence)storageData.getKeys(), (CharSequence)storageData.getUpdateKeys()) && StringUtils.equals((CharSequence)storageData.getColumnTypes(), (CharSequence)storageData.getUpdateColumnTypes());
    }

    private void deleteColumns(Connection connection, String tableName, String currentKeys, String updateKeys) throws Exception {
        List<String> cleanKeyList = this.getCleanKeyList(currentKeys);
        List<String> updateCleanKeyList = this.getCleanKeyList(updateKeys);
        List deleteKeys = cleanKeyList.stream().filter(key -> !updateCleanKeyList.contains(key)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(deleteKeys)) {
            String delColumns = deleteKeys.stream().map(key -> String.format(DROP_COLUMN_FORMAT, key)).collect(Collectors.joining(","));
            this.executeAlterTable(connection, tableName, delColumns);
        }
    }

    private void addColumns(Connection connection, String tableName, String keys, String updateKeys, String updateColumnTypes) throws Exception {
        List<String> cleanKeyList = this.getCleanKeyList(updateKeys);
        List addKeys = cleanKeyList.stream().filter(key -> !this.getCleanKeyList(keys).contains(key)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(addKeys)) {
            Map<String, String> fieldMap = this.buildFieldMap(updateKeys, updateColumnTypes);
            String addColumns = addKeys.stream().map(key -> String.format(ADD_COLUMN_FORMAT, key, fieldMap.get(key))).collect(Collectors.joining(","));
            this.executeAlterTable(connection, tableName, addColumns);
        }
    }

    private void changeColumns(Connection connection, String tableName, String currentKeys, String currentColumnTypes, String updateKeys, String updateColumnTypes) throws Exception {
        Map<String, String> originFieldMap = this.buildFieldMap(currentKeys, currentColumnTypes);
        Map<String, String> currentFieldMap = this.buildFieldMap(updateKeys, updateColumnTypes);
        List updateFields = currentFieldMap.entrySet().stream().filter(entry -> !StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)((CharSequence)originFieldMap.get(entry.getKey())))).map(Map.Entry::getKey).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(updateFields)) {
            String changeColumns = updateFields.stream().map(key -> String.format(CHANGE_COLUMN_FORMAT, key, currentFieldMap.get(key))).collect(Collectors.joining(","));
            this.executeAlterTable(connection, tableName, changeColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAlterTable(Connection connection, String tableName, String columnStatements) throws Exception {
        String sql = String.format("ALTER TABLE %s %s;", tableName, columnStatements);
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        finally {
            log.error("executeAlterTable error,sql:{}", (Object)sql);
        }
    }

    private List<String> getCleanKeyList(String keys) {
        return Arrays.stream(keys.split(",")).map(s -> s.split(":")[0]).collect(Collectors.toList());
    }

    @Override
    public boolean deleteTable(LogStorageData storageData) {
        String tableName = this.buildTableName(storageData.getClusterId(), storageData.getStoreId());
        DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + storageData.getClusterId());
        try (Statement statement = dataSource.getConnection().createStatement();){
            String createTableGrammar = String.format(DELETE_TABLE_FORMAT, tableName);
            statement.execute(createTableGrammar);
        }
        catch (SQLException e) {
            throw new MilogManageException("deleteTable error:" + e.getMessage());
        }
        this.deleteLogStorageTable(storageData, tableName);
        return true;
    }

    @Override
    public List<String> getColumnList(Long clusterId, String tableName) {
        ArrayList columnList = Lists.newArrayList();
        DataSource dataSource = (DataSource)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + clusterId);
        try {
            Connection connection = dataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, null, tableName, null);){
                while (resultSet.next()) {
                    String columnName = resultSet.getString("COLUMN_NAME");
                    columnList.add(columnName);
                }
            }
        }
        catch (Exception e) {
            log.error("getColumnList error,clusterId:{},tableName:{}", new Object[]{clusterId, tableName, e});
        }
        log.info("getColumnList,,clusterId:{},tableName:{},columnList:{}", new Object[]{clusterId, tableName, Constant.GSON.toJson((Object)columnList)});
        return columnList;
    }

    private void deleteLogStorageTable(LogStorageData storageData, String tableName) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MilogEsIndexDO::getLogType, (Object)storageData.getLogType())).eq(MilogEsIndexDO::getClusterId, (Object)storageData.getClusterId())).eq(MilogEsIndexDO::getIndexName, (Object)tableName);
        this.esIndexMapper.delete((Wrapper)lambdaQueryWrapper);
    }
}

