/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStructureEnum;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.common.validation.StoreValidation;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.EsIndexTemplate;
import org.apache.ozhera.log.manager.domain.LogTail;
import org.apache.ozhera.log.manager.mapper.MilogEsIndexMapper;
import org.apache.ozhera.log.manager.model.convert.MilogLogstoreConvert;
import org.apache.ozhera.log.manager.model.dto.EsInfoDTO;
import org.apache.ozhera.log.manager.model.dto.LogStoreDTO;
import org.apache.ozhera.log.manager.model.dto.MapDTO;
import org.apache.ozhera.log.manager.model.dto.MenuDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.model.vo.LogStoreParam;
import org.apache.ozhera.log.manager.service.BaseService;
import org.apache.ozhera.log.manager.service.LogStoreService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionService;
import org.apache.ozhera.log.manager.service.extension.resource.ResourceExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.EsDataServiceImpl;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.ozhera.log.manager.service.impl.MilogMiddlewareConfigServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class LogStoreServiceImpl
extends BaseService
implements LogStoreService {
    private static final Logger log = LoggerFactory.getLogger(LogStoreServiceImpl.class);
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogLogTailDao milogLogtailDao;
    @Resource
    private EsIndexTemplate esIndexTemplate;
    @Resource
    private StoreValidation storeValidation;
    @Resource
    private MilogMiddlewareConfigServiceImpl milogMiddlewareConfigService;
    @Resource
    private MilogEsIndexMapper milogEsIndexMapper;
    @Resource
    private LogTail logTail;
    @Resource
    private LogTailServiceImpl logTailService;
    private StoreExtensionService storeExtensionService;
    private ResourceExtensionService resourceExtensionService;
    private CommonExtensionService commonExtensionService;

    public void init() {
        this.storeExtensionService = StoreExtensionServiceFactory.getStoreExtensionService();
        this.resourceExtensionService = ResourceExtensionServiceFactory.getResourceExtensionService();
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
    }

    @Override
    public Result<String> newLogStore(LogStoreParam cmd) {
        if (null != cmd.getId()) {
            return this.updateLogStore(cmd);
        }
        return this.createLogStore(cmd);
    }

    private Result<String> createLogStore(LogStoreParam cmd) {
        String errorInfos = this.storeValidation.logStoreParamValid(cmd);
        if (StringUtils.isNotEmpty((CharSequence)errorInfos)) {
            return Result.failParam((String)errorInfos);
        }
        if (!cmd.getNameSameStatus().booleanValue() && this.logStoreDao.verifyExistByName(cmd.getLogstoreName(), null, cmd.getSpaceId())) {
            return new Result(CommonError.UnknownError.getCode(), "There is a store name with the same name", (Object)"");
        }
        List<MilogLogStoreDO> logStoreDOS = this.logStoreDao.queryBySpaceIdNamed(cmd.getSpaceId(), cmd.getLogstoreName());
        if (CollectionUtils.isNotEmpty(logStoreDOS)) {
            return Result.failParam((String)"The store name is duplicated, please fill in the name again");
        }
        MilogLogStoreDO storeDO = MilogLogstoreConvert.INSTANCE.fromCommand(cmd);
        this.wrapBaseCommon(storeDO, OperateEnum.ADD_OPERATE);
        this.storeExtensionService.storeResourceBinding(storeDO, cmd, OperateEnum.ADD_OPERATE);
        this.checkRequiredFieldExist(storeDO, cmd);
        boolean res = this.logStoreDao.newMilogLogStore(storeDO);
        if (res) {
            this.storeExtensionService.postProcessing(storeDO, cmd, OperateEnum.ADD_OPERATE);
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage());
        }
        log.warn("[MilogLogstoreService.newMilogLogstore] creator MilogLogstore err,logstoreName:{}", (Object)cmd.getLogstoreName());
        return new Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage());
    }

    private void checkRequiredFieldExist(MilogLogStoreDO storeDO, LogStoreParam cmd) {
        String keyList = storeDO.getKeyList();
        String columnTypeList = storeDO.getColumnTypeList();
        for (Pair<String, Pair<String, Integer>> requiredField : EsDataServiceImpl.requiredFields) {
            if (keyList.contains((CharSequence)requiredField.getKey())) continue;
            keyList = String.format("%s,%s:%s", keyList, requiredField.getKey(), ((Pair)requiredField.getValue()).getValue());
            columnTypeList = String.format("%s,%s", columnTypeList, ((Pair)requiredField.getValue()).getKey());
        }
        storeDO.setKeyList(keyList);
        storeDO.setColumnTypeList(columnTypeList);
        cmd.setKeyList(keyList);
        cmd.setColumnTypeList(columnTypeList);
    }

    @Override
    public MilogLogStoreDO buildLogStoreEsInfo(LogStoreParam storeParam, String creator) {
        EsInfoDTO esInfo = this.esIndexTemplate.getEsInfo(storeParam.getMachineRoom(), storeParam.getLogType());
        storeParam.setEsIndex(esInfo.getIndex());
        MilogLogStoreDO ml = MilogLogstoreConvert.INSTANCE.fromCommand(storeParam);
        ml.setEsClusterId(esInfo.getClusterId());
        this.wrapBaseCommon(ml, OperateEnum.ADD_OPERATE, creator);
        return ml;
    }

    @Override
    public Result<LogStoreDTO> getLogStoreById(Long id) {
        if (null == id) {
            return Result.failParam((String)"id can not be empty");
        }
        MilogLogStoreDO milogLogStoreDO = this.logStoreDao.queryById(id);
        LogStoreDTO logStoreDTO = new LogStoreDTO();
        if (null != milogLogStoreDO) {
            BeanUtil.copyProperties((Object)milogLogStoreDO, (Object)logStoreDTO, (String[])new String[0]);
            if (MoneUserContext.getCurrentUser().getIsAdmin().booleanValue()) {
                logStoreDTO.setSelectCustomIndex(Boolean.TRUE);
            }
            logStoreDTO.setEsResourceId(milogLogStoreDO.getEsClusterId());
            logStoreDTO.setLogTypeName(LogTypeEnum.queryNameByType((Integer)milogLogStoreDO.getLogType()));
            logStoreDTO.setMachineRoomName(this.commonExtensionService.getMachineRoomName(milogLogStoreDO.getMachineRoom()));
        }
        return Result.success((Object)logStoreDTO);
    }

    @Override
    public Result<List<MapDTO<String, Long>>> getLogStoreBySpaceId(Long spaceId) {
        List<MilogLogStoreDO> stores = this.logStoreDao.getMilogLogstoreBySpaceId(spaceId);
        ArrayList<MapDTO<String, Long>> ret = new ArrayList<MapDTO<String, Long>>();
        for (MilogLogStoreDO s : stores) {
            ret.add(new MapDTO<String, Long>(s.getLogstoreName(), s.getId()));
        }
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), ret);
    }

    @Override
    public Result<Map<String, Object>> getLogStoreByPage(String logstoreName, Long spaceId, int page, int pagesize) {
        Map<String, Object> ret = this.logStoreDao.getMilogLogstoreByPage(logstoreName, spaceId, page, pagesize);
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), ret);
    }

    @Override
    public Result<Map<String, Object>> getAllLogStore() {
        Map<String, Object> ret = this.logStoreDao.getAllMilogLogstore(MoneUserContext.getCurrentUser().getZone());
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), ret);
    }

    @Override
    public Result<List<MilogLogStoreDO>> getLogStoreByIds(List<Long> ids) {
        List<MilogLogStoreDO> ret = this.logStoreDao.getMilogLogstore(ids);
        return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage(), ret);
    }

    @Override
    public Result<String> updateLogStore(LogStoreParam param) {
        MilogLogStoreDO milogLogstoreDO = this.logStoreDao.queryById(param.getId());
        if (null == milogLogstoreDO) {
            return new Result(CommonError.ParamsError.getCode(), "logstore not found ");
        }
        if (!param.getLogType().equals(milogLogstoreDO.getLogType()) && 0 != this.milogLogtailDao.getTailCount(param.getId())) {
            return new Result(CommonError.ParamsError.getCode(), "Logtail has been created under logstore and does not allow you to change the log type");
        }
        String errorInfos = this.storeValidation.logStoreParamValid(param);
        if (StringUtils.isNotEmpty((CharSequence)errorInfos)) {
            return Result.failParam((String)errorInfos);
        }
        if (this.logStoreDao.verifyExistByName(param.getLogstoreName(), param.getId(), param.getSpaceId())) {
            return new Result(CommonError.UnknownError.getCode(), "There is a store name with the same name", (Object)"");
        }
        MilogLogStoreDO ml = MilogLogstoreConvert.INSTANCE.fromCommand(param);
        ml.setEsClusterId(milogLogstoreDO.getEsClusterId());
        ml.setEsIndex(milogLogstoreDO.getEsIndex());
        ml.setCtime(milogLogstoreDO.getCtime());
        ml.setCreator(milogLogstoreDO.getCreator());
        this.storeExtensionService.storeResourceBinding(ml, param, OperateEnum.UPDATE_OPERATE);
        this.wrapBaseCommon(ml, OperateEnum.UPDATE_OPERATE);
        this.checkRequiredFieldExist(ml, param);
        boolean updateRes = this.storeExtensionService.updateLogStore(ml);
        if (updateRes && this.storeExtensionService.sendConfigSwitch(param)) {
            this.storeExtensionService.postProcessing(ml, param, OperateEnum.UPDATE_OPERATE);
            this.logTail.handleStoreTail(milogLogstoreDO.getId());
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage());
        }
        return Result.success((Object)"success");
    }

    @Override
    public Result<Void> deleteLogStore(Long id) {
        MilogLogStoreDO logStore = this.logStoreDao.queryById(id);
        if (null == logStore) {
            return new Result(CommonError.ParamsError.getCode(), "logstore not found");
        }
        List<MilogLogTailDo> tails = this.milogLogtailDao.getMilogLogtailByStoreId(id);
        if (tails != null && tails.size() != 0) {
            return new Result(CommonError.ParamsError.getCode(), "There is a tail under the log store and cannot be deleted");
        }
        this.storeExtensionService.deleteStorePostProcessing(logStore);
        if (this.logStoreDao.deleteMilogSpace(id)) {
            this.storeExtensionService.postProcessing(logStore, null, OperateEnum.DELETE_OPERATE);
            this.logTailService.deleteConfigRemote(logStore.getSpaceId(), id, logStore.getMachineRoom(), LogStructureEnum.STORE);
            return new Result(CommonError.Success.getCode(), CommonError.Success.getMessage());
        }
        log.warn("[MilogLogstoreService.deleteMilogLogstore] delete Milogstore err,spaceId:{}", (Object)id);
        return new Result(CommonError.UnknownError.getCode(), CommonError.UnknownError.getMessage());
    }

    @Override
    public Result<List<Map<String, String>>> getStoreIps(Long storeId) {
        if (storeId == null) {
            return Result.failParam((String)"The parameter cannot be empty");
        }
        List<MilogLogTailDo> logtailDoList = this.milogLogtailDao.getMilogLogtailByStoreId(storeId);
        ArrayList res = new ArrayList();
        HashSet<String> existIpSet = new HashSet<String>();
        for (MilogLogTailDo tail : logtailDoList) {
            List<String> ipList = tail.getIps();
            if (!CollectionUtils.isNotEmpty(ipList)) continue;
            for (String ip : ipList) {
                if (existIpSet.contains(ip) || StringUtils.isEmpty((CharSequence)ip)) continue;
                HashMap<String, String> ferry = new HashMap<String, String>(2);
                ferry.put("label", ip);
                ferry.put("value", ip);
                res.add(ferry);
                existIpSet.add(ip);
            }
        }
        return Result.success(res);
    }

    @Override
    public Result<List<MenuDTO<Long, String>>> queryDeptExIndexList(String regionCode, Integer logTypeCode) {
        if (StringUtils.isBlank((CharSequence)regionCode) || null == logTypeCode) {
            return Result.failParam((String)"regionCode or logTypeCode can not empty");
        }
        List<MilogMiddlewareConfig> middlewareConfigEs = this.milogMiddlewareConfigService.getESConfigs(regionCode);
        middlewareConfigEs = this.resourceExtensionService.currentUserConfigFilter(middlewareConfigEs);
        List menuDTOS = middlewareConfigEs.stream().map(config -> {
            MenuDTO<Long, String> menuDTO = new MenuDTO<Long, String>();
            menuDTO.setKey(config.getId());
            menuDTO.setLabel(config.getAlias());
            menuDTO.setChildren(this.getExIndexByLogType(config.getId(), logTypeCode));
            return menuDTO;
        }).collect(Collectors.toList());
        return Result.success(menuDTOS);
    }

    private List<MenuDTO<Long, String>> getExIndexByLogType(Long clusterId, Integer logTypeCode) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"cluster_id", (Object)clusterId)).eq((Object)"log_type", (Object)logTypeCode);
        List esIndexDOS = this.milogEsIndexMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)esIndexDOS)) {
            return esIndexDOS.stream().map(indexDO -> {
                MenuDTO<Long, String> menuDTO = new MenuDTO<Long, String>();
                menuDTO.setKey(indexDO.getId());
                menuDTO.setLabel(indexDO.getIndexName());
                return menuDTO;
            }).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public Result<String> redistributeStoreConfig(Long storeId) {
        if (null == storeId) {
            return Result.failParam((String)"storeId can not be empty");
        }
        this.logTail.handleStoreTail(storeId);
        return Result.success((Object)"success");
    }
}

