/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.dao.MilogMachineDao;
import org.apache.ozhera.log.manager.model.bo.MachineParamParam;
import org.apache.ozhera.log.manager.model.bo.MachineQueryParam;
import org.apache.ozhera.log.manager.model.pojo.MiLogMachine;
import org.apache.ozhera.log.manager.service.MilogMachineService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogMachineServiceImpl
implements MilogMachineService {
    private static final Logger log = LoggerFactory.getLogger(MilogMachineServiceImpl.class);
    @Resource
    MilogMachineDao milogMachineDao;

    @Override
    public Result<String> addMachineInfo(MachineParamParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getIp())) {
            return Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"The IP address cannot be empty");
        }
        if (null == param.getType()) {
            return Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"Machine type cannot be empty");
        }
        this.milogMachineDao.insert(param);
        return Result.success();
    }

    @Override
    public Result<String> deleteMachineInfo(Long id) {
        if (null == id) {
            return Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"ID cannot be empty");
        }
        this.milogMachineDao.deleteMachineInfo(id);
        return Result.success();
    }

    @Override
    public Result<Map<String, Object>> queryMachineByPage(MachineQueryParam param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("milogSpaceList", this.milogMachineDao.queryMachinePage(param));
        result.put("total", this.milogMachineDao.queryMachinePageCount(param));
        result.put("page", param.getPageNum());
        result.put("pageSize", param.getPageSize());
        return Result.success(result);
    }

    @Override
    public Result<MachineParamParam> queryMachineInfoById(Long id) {
        if (null == id) {
            return Result.fail((Integer)CommonError.ParamsError.getCode(), (String)"ID cannot be empty");
        }
        MiLogMachine miLogMachine = this.milogMachineDao.queryById(id);
        return Result.success((Object)((MachineParamParam)miLogMachine));
    }
}

