/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.List;

public enum MachineRegionEnum {
    CN_MACHINE("cn", "\u5927\u9646\u673a\u623f", Arrays.asList("c1", "c2", "c3"));

    private final String en;
    private final String cn;
    private List<String> childZone;

    private MachineRegionEnum(String en, String cn, List<String> childZone) {
        this.en = en;
        this.cn = cn;
        this.childZone = childZone;
    }

    public static String queryMchineInfoByZone(String zone) {
        for (MachineRegionEnum machineRegionEnum : MachineRegionEnum.values()) {
            if (!machineRegionEnum.getChildZone().contains(zone)) continue;
            return String.format("%s%s", machineRegionEnum.getEn(), machineRegionEnum.getCn());
        }
        return "";
    }

    public static MachineRegionEnum queryMchineRegionByZone(String zone) {
        for (MachineRegionEnum machineRegionEnum : MachineRegionEnum.values()) {
            if (!machineRegionEnum.getChildZone().contains(zone)) continue;
            return machineRegionEnum;
        }
        return null;
    }

    public static String queryCnByEn(String en) {
        MachineRegionEnum machineRegionEnum = MachineRegionEnum.queryRegionByEn(en);
        if (null != machineRegionEnum) {
            return machineRegionEnum.getCn();
        }
        return "";
    }

    public static MachineRegionEnum queryRegionByEn(String en) {
        for (MachineRegionEnum machineRegionEnum : MachineRegionEnum.values()) {
            if (!machineRegionEnum.getEn().equals(en)) continue;
            return machineRegionEnum;
        }
        return null;
    }

    public String getEn() {
        return this.en;
    }

    public String getCn() {
        return this.cn;
    }

    public List<String> getChildZone() {
        return this.childZone;
    }
}

