/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.util.Locale;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public abstract class AbstractJodaTypeToStringConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return this.conversionString(conversionContext, "print") + ".trim()";
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        if (conversionContext.getDateFormat() != null) {
            return java.util.Collections.singleton(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"));
        }
        return Collections.asSet(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"), conversionContext.getTypeFactory().getType(Locale.class));
    }

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return this.conversionString(conversionContext, this.parseMethod());
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        if (conversionContext.getDateFormat() != null) {
            return java.util.Collections.singleton(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"));
        }
        return Collections.asSet(conversionContext.getTypeFactory().getType("org.joda.time.format.DateTimeFormat"), conversionContext.getTypeFactory().getType(Locale.class));
    }

    private String conversionString(ConversionContext conversionContext, String method) {
        StringBuilder conversionString = new StringBuilder(ConversionUtils.dateTimeFormat(conversionContext));
        conversionString.append(this.dateFormatPattern(conversionContext));
        conversionString.append(".");
        conversionString.append(method);
        conversionString.append("( <SOURCE> )");
        return conversionString.toString();
    }

    private String dateFormatPattern(ConversionContext conversionContext) {
        StringBuilder conversionString = new StringBuilder();
        conversionString.append(".forPattern(");
        String dateFormat = conversionContext.getDateFormat();
        if (dateFormat == null) {
            conversionString.append(this.defaultDateFormatPattern(conversionContext));
        } else {
            conversionString.append(" \"");
            conversionString.append(dateFormat);
            conversionString.append("\"");
        }
        conversionString.append(" )");
        return conversionString.toString();
    }

    private String defaultDateFormatPattern(ConversionContext conversionContext) {
        return " " + ConversionUtils.dateTimeFormat(conversionContext) + ".patternForStyle( \"" + this.formatStyle() + "\", " + ConversionUtils.locale(conversionContext) + ".getDefault() )";
    }

    protected abstract String formatStyle();

    protected abstract String parseMethod();
}

