/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.nacos;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;

public class NacosConfigServiceWrapper {
    private static final String INNERCLASS_SYMBOL = "$";
    private static final String INNERCLASS_COMPATIBLE_SYMBOL = "___";
    private ConfigService configService;

    public NacosConfigServiceWrapper(ConfigService configService) {
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void addListener(String dataId, String group, Listener listener) throws NacosException {
        this.configService.addListener(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), listener);
    }

    public String getConfig(String dataId, String group, long timeout) throws NacosException {
        return this.configService.getConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), timeout);
    }

    public boolean publishConfig(String dataId, String group, String content) throws NacosException {
        return this.configService.publishConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group), content);
    }

    public boolean removeConfig(String dataId, String group) throws NacosException {
        return this.configService.removeConfig(this.handleInnerSymbol(dataId), this.handleInnerSymbol(group));
    }

    private String handleInnerSymbol(String param) {
        if (param == null) {
            return null;
        }
        return param.replace(INNERCLASS_SYMBOL, INNERCLASS_COMPATIBLE_SYMBOL).replace('/', '-');
    }
}

