/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.metadata.MetadataServiceURLBuilder;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;

public class StandardMetadataServiceURLBuilder
implements MetadataServiceURLBuilder {
    public static final String NAME = "standard";

    @Override
    public List<URL> build(ServiceInstance serviceInstance) {
        Map<String, Map<String, String>> paramsMap = ServiceInstanceMetadataUtils.getMetadataServiceURLsParams(serviceInstance);
        ArrayList<URL> urls = new ArrayList<URL>(paramsMap.size());
        String serviceName = serviceInstance.getServiceName();
        String host = serviceInstance.getHost();
        for (Map.Entry<String, Map<String, String>> entry : paramsMap.entrySet()) {
            String protocol = entry.getKey();
            Map<String, String> params = entry.getValue();
            int port = Integer.parseInt(params.get("port"));
            URLBuilder urlBuilder = new URLBuilder().setHost(host).setPort(port).setProtocol(protocol).setPath(MetadataService.class.getName()).addParameter("timeout", ConfigurationUtils.get("dubbo.application.metadata.delay", 5000)).addParameter("side", "consumer");
            params.forEach((name, value) -> urlBuilder.addParameter((String)name, String.valueOf(value)));
            urlBuilder.addParameter("group", serviceName);
            urls.add(urlBuilder.build());
        }
        return urls;
    }
}

