/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.AbstractChannel;
import org.apache.dubbo.remoting.transport.netty4.NettyClient;
import org.apache.dubbo.remoting.utils.PayloadDropper;

final class NettyChannel
extends AbstractChannel {
    private static final Logger logger = LoggerFactory.getLogger(NettyChannel.class);
    private static final ConcurrentMap<io.netty.channel.Channel, NettyChannel> CHANNEL_MAP = new ConcurrentHashMap<io.netty.channel.Channel, NettyChannel>();
    private final io.netty.channel.Channel channel;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final AtomicBoolean active = new AtomicBoolean(false);

    private NettyChannel(io.netty.channel.Channel channel, URL url, ChannelHandler handler) {
        super(url, handler);
        if (channel == null) {
            throw new IllegalArgumentException("netty channel == null;");
        }
        this.channel = channel;
    }

    static NettyChannel getOrAddChannel(io.netty.channel.Channel ch, URL url, ChannelHandler handler) {
        if (ch == null) {
            return null;
        }
        NettyChannel ret = (NettyChannel)CHANNEL_MAP.get(ch);
        if (ret == null) {
            NettyChannel nettyChannel = new NettyChannel(ch, url, handler);
            if (ch.isActive()) {
                nettyChannel.markActive(true);
                ret = CHANNEL_MAP.putIfAbsent(ch, nettyChannel);
            }
            if (ret == null) {
                ret = nettyChannel;
            }
        }
        return ret;
    }

    static void removeChannelIfDisconnected(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && !ch.isActive() && (nettyChannel = (NettyChannel)CHANNEL_MAP.remove(ch)) != null) {
            nettyChannel.markActive(false);
        }
    }

    static void removeChannel(io.netty.channel.Channel ch) {
        NettyChannel nettyChannel;
        if (ch != null && (nettyChannel = (NettyChannel)CHANNEL_MAP.remove(ch)) != null) {
            nettyChannel.markActive(false);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed() && this.active.get();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void markActive(boolean isActive) {
        this.active.set(isActive);
    }

    @Override
    public void send(Object message, boolean sent) throws RemotingException {
        super.send(message, sent);
        boolean success = true;
        int timeout = 0;
        try {
            Throwable cause;
            ChannelFuture future = this.channel.writeAndFlush(message);
            if (sent) {
                timeout = this.getUrl().getPositiveParameter("timeout", 1000);
                success = future.await((long)timeout);
            }
            if ((cause = future.cause()) != null) {
                throw cause;
            }
        }
        catch (Throwable e) {
            NettyChannel.removeChannelIfDisconnected(this.channel);
            throw new RemotingException(this, "Failed to send message " + PayloadDropper.getRequestWithoutData(message) + " to " + this.getRemoteAddress() + ", cause: " + e.getMessage(), e);
        }
        if (!success) {
            throw new RemotingException((Channel)this, "Failed to send message " + PayloadDropper.getRequestWithoutData(message) + " to " + this.getRemoteAddress() + "in timeout(" + timeout + "ms) limit");
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            NettyChannel.removeChannelIfDisconnected(this.channel);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            this.attributes.clear();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Close netty channel " + this.channel);
            }
            this.channel.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.channel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NettyClient) {
            NettyClient client = (NettyClient)obj;
            return this.channel.equals(client.getNettyChannel());
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NettyChannel other = (NettyChannel)obj;
        return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
    }

    @Override
    public String toString() {
        return "NettyChannel [channel=" + this.channel + "]";
    }
}

