/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.serialize.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.ExtSerializerFactory;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import org.apache.dubbo.serialize.hessian.serializer.java8.DurationHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.InstantHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.Java8TimeSerializer;
import org.apache.dubbo.serialize.hessian.serializer.java8.LocalDateHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.LocalDateTimeHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.LocalTimeHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.MonthDayHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.OffsetDateTimeHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.OffsetTimeHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.PeriodHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.YearHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.YearMonthHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.ZoneIdSerializer;
import org.apache.dubbo.serialize.hessian.serializer.java8.ZoneOffsetHandle;
import org.apache.dubbo.serialize.hessian.serializer.java8.ZonedDateTimeHandle;

public class Java8SerializerFactory
extends ExtSerializerFactory {
    public static final AbstractSerializerFactory INSTANCE = new Java8SerializerFactory();

    private Java8SerializerFactory() {
        if (Java8SerializerFactory.isJava8()) {
            try {
                this.addSerializer(Class.forName("java.time.LocalTime"), (Serializer)Java8TimeSerializer.create(LocalTimeHandle.class));
                this.addSerializer(Class.forName("java.time.LocalDate"), (Serializer)Java8TimeSerializer.create(LocalDateHandle.class));
                this.addSerializer(Class.forName("java.time.LocalDateTime"), (Serializer)Java8TimeSerializer.create(LocalDateTimeHandle.class));
                this.addSerializer(Class.forName("java.time.Instant"), (Serializer)Java8TimeSerializer.create(InstantHandle.class));
                this.addSerializer(Class.forName("java.time.Duration"), (Serializer)Java8TimeSerializer.create(DurationHandle.class));
                this.addSerializer(Class.forName("java.time.Period"), (Serializer)Java8TimeSerializer.create(PeriodHandle.class));
                this.addSerializer(Class.forName("java.time.Year"), (Serializer)Java8TimeSerializer.create(YearHandle.class));
                this.addSerializer(Class.forName("java.time.YearMonth"), (Serializer)Java8TimeSerializer.create(YearMonthHandle.class));
                this.addSerializer(Class.forName("java.time.MonthDay"), (Serializer)Java8TimeSerializer.create(MonthDayHandle.class));
                this.addSerializer(Class.forName("java.time.OffsetDateTime"), (Serializer)Java8TimeSerializer.create(OffsetDateTimeHandle.class));
                this.addSerializer(Class.forName("java.time.ZoneOffset"), (Serializer)Java8TimeSerializer.create(ZoneOffsetHandle.class));
                this.addSerializer(Class.forName("java.time.OffsetTime"), (Serializer)Java8TimeSerializer.create(OffsetTimeHandle.class));
                this.addSerializer(Class.forName("java.time.ZonedDateTime"), (Serializer)Java8TimeSerializer.create(ZonedDateTimeHandle.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        return Java8SerializerFactory.isZoneId(cl) ? ZoneIdSerializer.getInstance() : super.getSerializer(cl);
    }

    private static boolean isZoneId(Class cl) {
        try {
            return Java8SerializerFactory.isJava8() && Class.forName("java.time.ZoneId").isAssignableFrom(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean isJava8() {
        String javaVersion = System.getProperty("java.specification.version");
        return Double.valueOf(javaVersion) >= 1.8;
    }
}

