/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppCapacityAutoAdjustMapper;
import org.apache.ozhera.monitor.dao.model.AppCapacityAutoAdjust;
import org.apache.ozhera.monitor.dao.model.AppCapacityAutoAdjustExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class AppCapacityAutoAdjustDao {
    private static final Logger log = LoggerFactory.getLogger(AppCapacityAutoAdjustDao.class);
    @Resource
    private AppCapacityAutoAdjustMapper appCapacityAutoAdjustMapper;

    public Long count(AppCapacityAutoAdjust appCapacityAutoAdjust) {
        AppCapacityAutoAdjustExample example = new AppCapacityAutoAdjustExample();
        AppCapacityAutoAdjustExample.Criteria ca = example.createCriteria();
        if (appCapacityAutoAdjust.getStatus() != null) {
            ca.andStatusEqualTo(appCapacityAutoAdjust.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (appCapacityAutoAdjust.getAutoCapacity() != null) {
            ca.andAutoCapacityEqualTo(appCapacityAutoAdjust.getAutoCapacity());
        }
        if (appCapacityAutoAdjust.getAppId() != null) {
            ca.andAppIdEqualTo(appCapacityAutoAdjust.getAppId());
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjust.getContainer())) {
            ca.andContainerLike("%" + appCapacityAutoAdjust.getContainer() + "%");
        }
        example.setOrderByClause("id desc");
        try {
            return this.appCapacityAutoAdjustMapper.countByExample(example);
        }
        catch (Exception e) {
            log.error("AppCapacityAutoAdjustDao#count error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<AppCapacityAutoAdjust> query(AppCapacityAutoAdjust appCapacityAutoAdjust, Integer pageCount, Integer pageNum) {
        if (pageCount == null) {
            pageCount = 1;
        }
        if (pageNum == null) {
            pageNum = 10;
        }
        AppCapacityAutoAdjustExample example = new AppCapacityAutoAdjustExample();
        AppCapacityAutoAdjustExample.Criteria ca = example.createCriteria();
        if (appCapacityAutoAdjust.getStatus() != null) {
            ca.andStatusEqualTo(appCapacityAutoAdjust.getStatus());
        } else {
            ca.andStatusEqualTo(0);
        }
        if (appCapacityAutoAdjust.getAutoCapacity() != null) {
            ca.andAutoCapacityEqualTo(appCapacityAutoAdjust.getAutoCapacity());
        }
        if (appCapacityAutoAdjust.getAppId() != null) {
            ca.andAppIdEqualTo(appCapacityAutoAdjust.getAppId());
        }
        if (appCapacityAutoAdjust.getPipelineId() != null) {
            ca.andPipelineIdEqualTo(appCapacityAutoAdjust.getPipelineId());
        }
        if (StringUtils.isNotBlank((CharSequence)appCapacityAutoAdjust.getContainer())) {
            ca.andContainerLike("%" + appCapacityAutoAdjust.getContainer() + "%");
        }
        example.setOffset((pageCount - 1) * pageNum);
        example.setLimit(pageNum);
        example.setOrderByClause("id desc");
        try {
            return this.appCapacityAutoAdjustMapper.selectByExample(example);
        }
        catch (Exception e) {
            log.error("AppCapacityAutoAdjustDao#query error!" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public AppCapacityAutoAdjust getById(Integer id) {
        if (id == null) {
            log.info("AppCapacityAutoAdjustDao.getById id is null!");
            return null;
        }
        return this.appCapacityAutoAdjustMapper.selectByPrimaryKey(id);
    }

    public int create(AppCapacityAutoAdjust appCapacityAutoAdjust) {
        if (null == appCapacityAutoAdjust) {
            log.error("[AppCapacityAutoAdjustDao.create] null appCapacityAutoAdjust");
            return 0;
        }
        appCapacityAutoAdjust.setCreateTime(new Date());
        appCapacityAutoAdjust.setUpdateTime(new Date());
        appCapacityAutoAdjust.setStatus(0);
        try {
            int affected = this.appCapacityAutoAdjustMapper.insert(appCapacityAutoAdjust);
            if (affected < 1) {
                log.warn("[AppCapacityAutoAdjustDao.create] failed to insert AppCapacityAutoAdjust: {}", (Object)appCapacityAutoAdjust.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppCapacityAutoAdjustDao.create] failed to insert AppCapacityAutoAdjust: {}, err: {}", (Object)appCapacityAutoAdjust.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int update(AppCapacityAutoAdjust appCapacityAutoAdjust) {
        if (null == appCapacityAutoAdjust) {
            log.error("[AppCapacityAutoAdjustDao.update] null appCapacityAutoAdjust");
            return 0;
        }
        appCapacityAutoAdjust.setUpdateTime(new Date());
        try {
            int affected = this.appCapacityAutoAdjustMapper.updateByPrimaryKey(appCapacityAutoAdjust);
            if (affected < 1) {
                log.warn("[AppCapacityAutoAdjustDao.update] failed to update appCapacityAutoAdjust: {}", (Object)appCapacityAutoAdjust.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppCapacityAutoAdjustDao.update] failed to update appCapacityAutoAdjust: {}, err: {}", (Object)appCapacityAutoAdjust.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

