/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.param.alert;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ozhera.prometheus.agent.param.BaseParam;
import org.apache.ozhera.prometheus.agent.param.alert.Matcher;

public class RuleSilenceParam
extends BaseParam {
    private String id;
    private List<Matcher> matcher;
    private Long startsAt;
    private Long endsAt;
    private String comment;
    private String createdBy;

    @Override
    public boolean argCheck() {
        if (this.comment.equals("") || this.comment.isEmpty()) {
            return false;
        }
        if (!this.ValidateMatchers(this.matcher)) {
            return false;
        }
        return this.startsAt != null && this.endsAt != null && this.startsAt >= this.endsAt;
    }

    private boolean ValidateMatchers(List<Matcher> matchers) {
        AtomicBoolean valid = new AtomicBoolean(true);
        matchers.forEach(matcher -> {
            if (matcher.getName().isEmpty() || matcher.getValue().isEmpty() || !matcher.isEqual() && matcher.isRegex()) {
                valid.set(false);
            }
        });
        return valid.get();
    }

    public String getId() {
        return this.id;
    }

    public List<Matcher> getMatcher() {
        return this.matcher;
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMatcher(List<Matcher> matcher) {
        this.matcher = matcher;
    }

    public void setStartsAt(Long startsAt) {
        this.startsAt = startsAt;
    }

    public void setEndsAt(Long endsAt) {
        this.endsAt = endsAt;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleSilenceParam)) {
            return false;
        }
        RuleSilenceParam other = (RuleSilenceParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startsAt = this.getStartsAt();
        Long other$startsAt = other.getStartsAt();
        if (this$startsAt == null ? other$startsAt != null : !((Object)this$startsAt).equals(other$startsAt)) {
            return false;
        }
        Long this$endsAt = this.getEndsAt();
        Long other$endsAt = other.getEndsAt();
        if (this$endsAt == null ? other$endsAt != null : !((Object)this$endsAt).equals(other$endsAt)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Matcher> this$matcher = this.getMatcher();
        List<Matcher> other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !((Object)this$matcher).equals(other$matcher)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        return !(this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RuleSilenceParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startsAt = this.getStartsAt();
        result = result * 59 + ($startsAt == null ? 43 : ((Object)$startsAt).hashCode());
        Long $endsAt = this.getEndsAt();
        result = result * 59 + ($endsAt == null ? 43 : ((Object)$endsAt).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Matcher> $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : ((Object)$matcher).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RuleSilenceParam(super=" + super.toString() + ", id=" + this.getId() + ", matcher=" + String.valueOf(this.getMatcher()) + ", startsAt=" + this.getStartsAt() + ", endsAt=" + this.getEndsAt() + ", comment=" + this.getComment() + ", createdBy=" + this.getCreatedBy() + ")";
    }
}

