/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.common;

import com.xiaomi.data.push.common.Utils;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class SnowFlake {
    protected long workerId;
    protected long datacenterId;
    protected long sequence;
    private static final long START_STMP = 1617206400000L;
    private long workerIdBits = 8L;
    private long datacenterIdBits = 2L;
    protected long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    protected long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long sequenceBits = 12L;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long workerIdShift = this.sequenceBits;
    private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
    private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
    protected long lastTimestamp = -1L;
    private final byte[] lock = new byte[0];
    private static AtomicLong STORE_CNT = new AtomicLong();

    public SnowFlake() {
        this.datacenterId = this.makeDatacenterId(this.maxDatacenterId);
        this.workerId = this.makeWorkerId(this.datacenterId, this.maxWorkerId);
        this.sequence = 0L;
    }

    public SnowFlake(long datacenterId, long workerId, long sequence) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0\r\n", this.maxWorkerId));
        }
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0\r\n", this.maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.sequence = sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextId() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                System.err.printf("clock is moving backwards.  Rejecting requests until %d.", this.lastTimestamp);
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & this.sequenceMask;
                if (this.sequence == 0L) {
                    timestamp = this.getNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.updateLastTimestamp(timestamp);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return timestamp - 1617206400000L << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
        }
    }

    protected long makeWorkerId(long datacenterId, long maxWorkerId) {
        long workId = this.randomLong(this.maxDatacenterId);
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(datacenterId);
            String localIp = Utils.getIp();
            sb.append(localIp);
            String name = ManagementFactory.getRuntimeMXBean().getName();
            if (null != name && !name.isEmpty()) {
                sb.append(name.split("@")[0]);
            }
            sb.append(this.randomLong(this.maxDatacenterId));
            workId = (long)(sb.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
        }
        catch (Exception e) {
            System.out.println("makeWorkerId Exception:" + e.getMessage());
        }
        return workId;
    }

    protected long recoverLastTimestamp() {
        return -1L;
    }

    private void updateLastTimestamp(long newTime) {
        this.lastTimestamp = newTime;
        this.storeLastTimestamp(this.lastTimestamp);
    }

    protected void storeLastTimestamp(long lastTimestamp) {
        STORE_CNT.addAndGet(1L);
    }

    private long randomLong(long maxId) {
        return ThreadLocalRandom.current().nextLong(0L, maxId);
    }

    protected long makeDatacenterId(long maxDatacenterId) {
        long datacenterId = 0L;
        return datacenterId;
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public long getDatacenterId() {
        return this.datacenterId;
    }

    private long getNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
            if (lastTimestamp - timestamp <= 3000L) continue;
            throw new RuntimeException(String.format("clock is moving backwards.  Rejecting requests until %s.", lastTimestamp));
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }
}

