/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.Nutz;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocContext;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.lang.util.NutMap;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.NutMvcContext;
import org.nutz.mvc.RequestPath;
import org.nutz.mvc.config.AtMap;
import org.nutz.mvc.impl.NutMessageMap;
import org.nutz.mvc.ioc.SessionIocContext;

public abstract class Mvcs {
    public static final String DEFAULT_MSGS = "$default";
    public static final String MSG = "msg";
    public static final String LOCALE_KEY = "nutz_mvc_localization_key";
    public static boolean disableFastClassInvoker = false;
    public static boolean DISPLAY_METHOD_LINENUMBER = true;
    public static boolean SKIP_COMMITTED = false;
    public static boolean DISABLE_X_POWERED_BY = false;
    public static String X_POWERED_BY = "nutz/" + Nutz.version() + " <nutzam.com>";
    private static String default_localization_key = null;
    private static final ThreadLocal<String> NAME = new ThreadLocal();
    @Deprecated
    public static NutMvcContext ctx;
    private static ServletContext def_servletContext;
    private static ThreadLocal<ServletContext> servletContext;

    public static Map<String, Object> getLocaleMessage(String key) {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (null != msgss) {
            return msgss.get(key);
        }
        return null;
    }

    public static Map<String, String> getMessages(ServletRequest req) {
        return (Map)req.getAttribute(MSG);
    }

    public static NutMessageMap getMessageMap(ServletRequest req) {
        return (NutMessageMap)req.getAttribute(MSG);
    }

    public static String getMessage(ServletRequest req, String key) {
        Map<String, String> map = Mvcs.getMessages(req);
        if (null != map) {
            return map.get(key);
        }
        return null;
    }

    public static String getLocalizationKey() {
        return (String)Mvcs.getSessionAttrSafe(LOCALE_KEY);
    }

    public static boolean setLocalizationKey(String key) {
        HttpSession sess = Mvcs.getHttpSession();
        if (null == sess) {
            return false;
        }
        sess.setAttribute(LOCALE_KEY, (Object)key);
        return true;
    }

    public static Set<String> getLocalizationKeySet() {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (null == msgss) {
            return new HashSet<String>();
        }
        return msgss.keySet();
    }

    public static void setDefaultLocalizationKey(String key) {
        default_localization_key = key;
    }

    public static String getDefaultLocalizationKey() {
        return default_localization_key;
    }

    public static void updateRequestAttributes(HttpServletRequest req) {
        Map<String, Map<String, Object>> msgss = Mvcs.getMessageSet();
        if (msgss == null && !Mvcs.ctx().localizations.isEmpty()) {
            msgss = Mvcs.ctx().localizations.values().iterator().next();
        }
        if (null != msgss) {
            Map<String, Object> msgs = null;
            String lKey = Strings.sBlank(Mvcs.getLocalizationKey(), Mvcs.getDefaultLocalizationKey());
            if (!Strings.isBlank(lKey)) {
                msgs = msgss.get(lKey);
            }
            if (null == msgs && msgss.size() > 0) {
                msgs = msgss.values().iterator().next();
            }
            req.setAttribute(MSG, msgs);
        }
        req.setAttribute("base", (Object)req.getContextPath());
        req.setAttribute("$request", (Object)req);
    }

    public static String getRequestPath(HttpServletRequest req) {
        return Mvcs.getRequestPathObject(req).getPath();
    }

    public static RequestPath getRequestPathObject(HttpServletRequest req) {
        String url = req.getPathInfo();
        if (null == url) {
            url = req.getServletPath();
        }
        return Mvcs.getRequestPathObject(url);
    }

    public static RequestPath getRequestPathObject(String url) {
        RequestPath rr = new RequestPath();
        rr.setUrl(url);
        if (null != url) {
            int lio = 0;
            if (!url.endsWith("/")) {
                int ll = url.lastIndexOf(47);
                lio = url.lastIndexOf(46);
                if (lio < ll) {
                    lio = -1;
                }
            }
            if (lio > 0) {
                rr.setPath(url.substring(0, lio));
                rr.setSuffix(url.substring(lio + 1));
            } else {
                rr.setPath(url);
                rr.setSuffix("");
            }
        } else {
            rr.setPath("");
            rr.setSuffix("");
        }
        return rr;
    }

    public static void deposeSession(HttpSession session) {
        if (session != null) {
            new SessionIocContext(session).depose();
        }
    }

    public static void write(HttpServletResponse resp, Object obj, JsonFormat format) throws IOException {
        Mvcs.write(resp, resp.getWriter(), obj, format);
    }

    public static void write(HttpServletResponse resp, Writer writer, Object obj, JsonFormat format) throws IOException {
        resp.setHeader("Cache-Control", "no-cache");
        if (resp.getContentType() == null) {
            resp.setContentType("text/plain");
        }
        Json.toJson(writer, obj, format);
        resp.flushBuffer();
    }

    public static NutMvcContext ctx() {
        ServletContext sc = Mvcs.getServletContext();
        if (sc == null) {
            if (ctx == null) {
                ctx = new NutMvcContext();
            }
            return ctx;
        }
        NutMvcContext c = (NutMvcContext)Mvcs.getServletContext().getAttribute("__nutz__mvc__ctx");
        if (c == null) {
            c = new NutMvcContext();
            Mvcs.getServletContext().setAttribute("__nutz__mvc__ctx", (Object)c);
            ctx = c;
        }
        return c;
    }

    public static final HttpServletRequest getReq() {
        return Mvcs.reqt().getAs(HttpServletRequest.class, "req");
    }

    public static final HttpServletResponse getResp() {
        return Mvcs.reqt().getAs(HttpServletResponse.class, "resp");
    }

    public static final String getName() {
        return NAME.get();
    }

    public static final ActionContext getActionContext() {
        return Mvcs.reqt().getAs(ActionContext.class, "ActionContext");
    }

    public static void set(String name, HttpServletRequest req, HttpServletResponse resp) {
        NAME.set(name);
        Mvcs.reqt().set("req", req);
        Mvcs.reqt().set("resp", resp);
    }

    public static void setServletContext(ServletContext servletContext) {
        if (servletContext == null) {
            Mvcs.servletContext.remove();
        }
        if (def_servletContext == null) {
            def_servletContext = servletContext;
        }
        Mvcs.servletContext.set(servletContext);
    }

    public static void setActionContext(ActionContext actionContext) {
        Mvcs.reqt().set("ActionContext", actionContext);
    }

    public static ServletContext getServletContext() {
        ServletContext cnt = servletContext.get();
        if (cnt != null) {
            return cnt;
        }
        return def_servletContext;
    }

    public static void setIocContext(IocContext iocContext) {
        Mvcs.reqt().set("IocContext", iocContext);
    }

    public static IocContext getIocContext() {
        return Mvcs.reqt().getAs(IocContext.class, "IocContext");
    }

    public static Ioc getIoc() {
        return Mvcs.ctx().iocs.get(Mvcs.getName());
    }

    public static void setIoc(Ioc ioc) {
        Mvcs.ctx().iocs.put(Mvcs.getName(), ioc);
    }

    public static AtMap getAtMap() {
        return Mvcs.ctx().atMaps.get(Mvcs.getName());
    }

    public static void setAtMap(AtMap atmap) {
        Mvcs.ctx().atMaps.put(Mvcs.getName(), atmap);
    }

    public static Map<String, Map<String, Object>> getMessageSet() {
        return Mvcs.ctx().localizations.get(Mvcs.getName());
    }

    public static void setMessageSet(Map<String, Map<String, Object>> messageSet) {
        Mvcs.ctx().localizations.put(Mvcs.getName(), messageSet);
    }

    public static void setNutConfig(NutConfig config) {
        Mvcs.ctx().nutConfigs.put(Mvcs.getName(), config);
    }

    public static NutConfig getNutConfig() {
        return Mvcs.ctx().nutConfigs.get(Mvcs.getName());
    }

    public static Context resetALL() {
        Context context = Mvcs.reqt();
        NAME.set(null);
        Mvcs.ctx().removeReqCtx();
        return context;
    }

    public static HttpSession getHttpSession() {
        return Mvcs.getHttpSession(true);
    }

    public static HttpSession getHttpSession(boolean createNew) {
        HttpServletRequest req = Mvcs.getReq();
        if (null == req) {
            return null;
        }
        return req.getSession(createNew);
    }

    public static void close() {
        Mvcs.ctx().clear();
        Mvcs.ctx().close();
        ctx = new NutMvcContext();
    }

    public static Context reqt() {
        return Mvcs.ctx().reqCtx();
    }

    public static Object getSessionAttrSafe(String key) {
        try {
            HttpSession session = Mvcs.getHttpSession(false);
            return session != null ? session.getAttribute(key) : null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setSessionAttrSafe(String key, Object val, boolean sessionCreate) {
        try {
            HttpSession session = Mvcs.getHttpSession(sessionCreate);
            if (session != null) {
                session.setAttribute(key, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NutMap toParamMap(Reader r, String enc) throws IOException {
        try {
            NutMap map = new NutMap();
            char[] buf = new char[1];
            StringBuilder sb = new StringBuilder();
            while (true) {
                int len;
                if ((len = r.read(buf)) == 0) {
                    continue;
                }
                if (buf[0] == '&' || len < 0) {
                    String[] tmp = sb.toString().split("=");
                    if (tmp != null && tmp.length == 2) {
                        map.put(URLDecoder.decode(tmp[0], enc), URLDecoder.decode(tmp[1], enc));
                    }
                    if (len < 0) break;
                    sb.setLength(0);
                    continue;
                }
                sb.append(buf[0]);
            }
            return map;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
    }

    static {
        servletContext = new ThreadLocal();
    }
}

