/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.netty;

import com.google.common.collect.Maps;
import com.xiaomi.data.push.rpc.common.InvokeCallback;
import com.xiaomi.data.push.rpc.common.Pair;
import com.xiaomi.data.push.rpc.common.RPCHook;
import com.xiaomi.data.push.rpc.common.RemotingHelper;
import com.xiaomi.data.push.rpc.common.RemotingUtil;
import com.xiaomi.data.push.rpc.exception.RemotingConnectException;
import com.xiaomi.data.push.rpc.exception.RemotingSendRequestException;
import com.xiaomi.data.push.rpc.exception.RemotingTimeoutException;
import com.xiaomi.data.push.rpc.exception.RemotingTooMuchRequestException;
import com.xiaomi.data.push.rpc.netty.ChannelEventListener;
import com.xiaomi.data.push.rpc.netty.ConnectionListener;
import com.xiaomi.data.push.rpc.netty.NettyClientConfig;
import com.xiaomi.data.push.rpc.netty.NettyDecoder;
import com.xiaomi.data.push.rpc.netty.NettyEncoder;
import com.xiaomi.data.push.rpc.netty.NettyEvent;
import com.xiaomi.data.push.rpc.netty.NettyEventType;
import com.xiaomi.data.push.rpc.netty.NettyRemotingAbstract;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.netty.RemotingClient;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger log = LoggerFactory.getLogger((String)"JCommon");
    private static final long LockTimeoutMillis = 3000L;
    public final AttributeKey<String> sa = AttributeKey.newInstance((String)("server_addr_name_" + System.currentTimeMillis()));
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private Function<String, String> getAddrsFunc;
    private AtomicReference<String> address = new AtomicReference<String>("");

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(this){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(this){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    public int getChannelNum() {
        return this.channelTables.size();
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(this){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        Bootstrap handler = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder()});
                if (NettyRemotingClient.this.nettyClientConfig.isIdle()) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds())});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new NettyConnetManageHandler(NettyRemotingClient.this.nettyClientConfig), new NettyClientHandler()});
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error("scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecuter.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecuter != null) {
                this.nettyEventExecuter.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    public void closeAllChannel() {
        try {
            HashMap channels = Maps.newHashMap();
            this.channelTables.forEach((k, v) -> channels.put(k, v));
            channels.forEach((k, v) -> this.closeChannel((String)k, v.getChannel()));
        }
        catch (Exception ex) {
            log.error("closeAllChannel error:{}", (Object)ex.getMessage());
        }
    }

    public void closeChannel(String addr) {
        block10: {
            if (null == addr) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        ChannelWrapper c = this.channelTables.get(addr);
                        if (null != c) {
                            this.channelTables.remove(addr);
                        }
                        RemotingUtil.closeChannel(c.getChannel());
                        break block10;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception:{}", (Object)e.getMessage());
                        break block10;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block9: {
            if (null == channel || null == addr) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        this.channelTables.remove(addr);
                        RemotingUtil.closeChannel(channel);
                        break block9;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception:{}", (Object)e.getMessage());
                        break block9;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception");
            }
        }
    }

    @Override
    public void registerRPCHook(RPCHook rpcHook) {
    }

    public void closeChannel(Channel channel) {
        if (null == channel) {
            return;
        }
        String addrRemote = (String)channel.attr(this.sa).get();
        this.closeChannel(addrRemote, channel);
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSync(addr, request, timeoutMillis, false);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis, boolean createChannel) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel;
        Channel channel2 = channel = createChannel ? this.getAndCreateChannel(addr) : this.getChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                return response;
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeSync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                if (this.nettyClientConfig.isClientCloseSocketIfTimeout()) {
                    this.closeChannel(addr, channel);
                    log.warn("invokeSync: close socket because of timeout, {}ms, {}", (Object)timeoutMillis, (Object)addr);
                }
                log.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)addr);
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    private Channel getAndCreateChannel(String addr) throws InterruptedException {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr, true);
    }

    private Channel getChannel(String addr) {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return null;
    }

    public Channel createChannel() throws InterruptedException {
        String addrs = this.getAddrsFunc.apply("createChannel");
        if (StringUtils.isEmpty((CharSequence)addrs)) {
            log.info("addr is null");
            return null;
        }
        return this.createChannel(addrs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Channel createChannel(String addr, boolean await) throws InterruptedException {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                boolean createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        Channel channel = cw.getChannel();
                        return channel;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) return null;
                log.info("create channel addr:{}", (Object)addr);
                ChannelFuture channelFuture = this.bootstrap.connect(RemotingHelper.string2SocketAddress(addr)).sync();
                if (this.nettyClientConfig.isReconnection()) {
                    channelFuture.addListener((GenericFutureListener)new ConnectionListener(this));
                }
                CountDownLatch countDownLatch = new CountDownLatch(1);
                MutableObject channel = new MutableObject();
                channelFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        log.info("create channel success:{}", (Object)addr);
                        channel.setValue((Object)channelFuture.channel());
                        SocketAddress address = channelFuture.channel().localAddress();
                        this.address.set(address.toString());
                        channelFuture.channel().attr(this.sa).set((Object)addr);
                        ChannelWrapper cw2 = new ChannelWrapper(channelFuture);
                        this.channelTables.put(addr, cw2);
                        countDownLatch.countDown();
                    } else {
                        countDownLatch.countDown();
                        channelFuture.channel().attr(this.sa).set((Object)addr);
                        log.info("create channel failure:{}", (Object)addr);
                    }
                });
                if (!await) return null;
                countDownLatch.await();
                Channel channel2 = (Channel)channel.getValue();
                return channel2;
            }
            catch (Exception e) {
                log.error("createChannel: create channel exception:{}", (Object)e.getMessage());
                return null;
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            log.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        if (StringUtils.isEmpty((CharSequence)addr)) {
            log.warn("addr is null");
            return;
        }
        Channel channel = this.createChannel(addr, true);
        if (channel != null && channel.isActive()) {
            try {
                this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(channel);
                throw e;
            }
        } else {
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void invokeAsync(RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) {
        this.channelTables.forEach((addr, channel) -> {
            if (channel != null && channel.getChannel().isActive()) {
                try {
                    this.invokeAsyncImpl(channel.getChannel(), request, timeoutMillis, invokeCallback);
                }
                catch (Exception e) {
                    log.warn("invokeAsync: send request exception, so close the channel[{}]", addr);
                    this.closeChannel((String)addr, channel.getChannel());
                }
            } else {
                this.closeChannel((String)addr, channel.getChannel());
            }
        });
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.createChannel(addr, true);
        if (channel != null && channel.isActive()) {
            try {
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = new Pair<NettyRequestProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public boolean isChannelWriteable(String addr) {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWriteable();
        }
        return true;
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public RPCHook getRPCHook() {
        return null;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    public List<String> getNamesrvAddrList() {
        return this.namesrvAddrList.get();
    }

    public void setGetAddrsFunc(Function<String, String> getAddrsFunc) {
        this.getAddrsFunc = getAddrsFunc;
    }

    public AtomicReference<String> getAddress() {
        return this.address;
    }

    static class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        public boolean isWriteable() {
            return this.channelFuture.channel().isWritable();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        private final NettyClientConfig nettyClientConfig;

        NettyConnetManageHandler(NettyClientConfig nettyClientConfig) {
            this.nettyClientConfig = nettyClientConfig;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String remote = remoteAddress.toString();
            log.info("connect {}", (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = (String)ctx.channel().attr(NettyRemotingClient.this.sa).get();
            log.warn("disconnect {}", (Object)remoteAddress);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = (String)ctx.channel().attr(NettyRemotingClient.this.sa).get();
            log.warn("close {}", (Object)remoteAddress);
            super.close(ctx, promise);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn("NETTY CLIENT PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                NettyRemotingClient.this.closeChannel(ctx.channel());
                if (NettyRemotingClient.this.channelEventListener != null) {
                    NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = (String)ctx.channel().attr(NettyRemotingClient.this.sa).get();
            log.warn("exceptionCaught {} {}", (Object)remoteAddress, (Object)cause.getMessage());
            NettyRemotingClient.this.closeChannel(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = (String)ctx.channel().attr(NettyRemotingClient.this.sa).get();
            log.warn("client channelInactive:{}", (Object)remoteAddress);
            EventLoop eventLoop = ctx.channel().eventLoop();
            if (this.nettyClientConfig.isReconnection()) {
                eventLoop.schedule(() -> NettyRemotingClient.this.createChannel(), 1L, TimeUnit.SECONDS);
            }
            super.channelInactive(ctx);
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }
}

