/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.common;

public enum ResourceTypeEnum {
    SERVICE_CHECK(0, "serviceCheck", 0),
    MYSQL(1, "MySQL", 7),
    REDIS(2, "Redis", 7),
    ES(3, "ES", 7),
    ROCKETMQ(4, "RocketMQ", 7),
    Nacos(5, "Nacos", 8),
    PROMETHEUS(6, "prometheus", 9),
    GRAFANA(7, "grafana", 9),
    ALERT_MANAGER(8, "alertManager", 9),
    CADVISOR(9, "cadvisor", 9),
    NODE_EXPORTER(10, "node-exporter", 9),
    HERA_APP(11, "HeraApp", 10),
    HERA_FE(12, "HeraFe", 11),
    HERA_WEBHOOK(13, "HeraWebhook", 12),
    OTHER(99, "Other", 19);

    private Integer type;
    private String typeName;
    private int order;

    private ResourceTypeEnum(int type, String typeName, int order) {
        this.type = type;
        this.typeName = typeName;
        this.order = order;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getOrder() {
        return this.order;
    }

    public static ResourceTypeEnum typeOf(String typeName) {
        for (ResourceTypeEnum rte : ResourceTypeEnum.values()) {
            if (!typeName.equals(rte.getTypeName())) continue;
            return rte;
        }
        return null;
    }
}

