/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor.dsl;

import net.logstash.logback.encoder.com.lmax.disruptor.BatchEventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.EventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.ExceptionHandler;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.ConsumerRepository;

public class ExceptionHandlerSetting<T> {
    private final EventHandler<T> eventHandler;
    private final ConsumerRepository<T> consumerRepository;

    ExceptionHandlerSetting(EventHandler<T> eventHandler, ConsumerRepository<T> consumerRepository) {
        this.eventHandler = eventHandler;
        this.consumerRepository = consumerRepository;
    }

    public void with(ExceptionHandler<? super T> exceptionHandler) {
        EventProcessor eventProcessor = this.consumerRepository.getEventProcessorFor(this.eventHandler);
        if (!(eventProcessor instanceof BatchEventProcessor)) {
            throw new RuntimeException("EventProcessor: " + eventProcessor + " is not a BatchEventProcessor " + "and does not support exception handlers");
        }
        ((BatchEventProcessor)eventProcessor).setExceptionHandler(exceptionHandler);
        this.consumerRepository.getBarrierFor(this.eventHandler).alert();
    }
}

