/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.LogicalIndexPointer;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ValuePointer;

public final class ScalarValuePointer
implements ValuePointer {
    private final LogicalIndexPointer logicalIndexPointer;
    private final Symbol inputSymbol;

    public ScalarValuePointer(LogicalIndexPointer logicalIndexPointer, Symbol inputSymbol) {
        this.logicalIndexPointer = Objects.requireNonNull(logicalIndexPointer, "logicalIndexPointer is null");
        this.inputSymbol = Objects.requireNonNull(inputSymbol, "inputSymbol is null");
    }

    public LogicalIndexPointer getLogicalIndexPointer() {
        return this.logicalIndexPointer;
    }

    public Symbol getInputSymbol() {
        return this.inputSymbol;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScalarValuePointer o = (ScalarValuePointer)obj;
        return Objects.equals(this.logicalIndexPointer, o.logicalIndexPointer) && Objects.equals(this.inputSymbol, o.inputSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.logicalIndexPointer, this.inputSymbol);
    }

    public static void serialize(ScalarValuePointer pointer, ByteBuffer byteBuffer) {
        LogicalIndexPointer.serialize(pointer.logicalIndexPointer, byteBuffer);
        Symbol.serialize(pointer.inputSymbol, byteBuffer);
    }

    public static void serialize(ScalarValuePointer pointer, DataOutputStream stream) throws IOException {
        LogicalIndexPointer.serialize(pointer.logicalIndexPointer, stream);
        Symbol.serialize(pointer.inputSymbol, stream);
    }

    public static ScalarValuePointer deserialize(ByteBuffer byteBuffer) {
        LogicalIndexPointer logicalIndexPointer = LogicalIndexPointer.deserialize(byteBuffer);
        Symbol inputSymbol = Symbol.deserialize(byteBuffer);
        return new ScalarValuePointer(logicalIndexPointer, inputSymbol);
    }
}

