/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer.base;

import java.util.List;
import org.apache.iotdb.session.subscription.consumer.AckStrategy;
import org.apache.iotdb.session.subscription.consumer.ConsumeListener;
import org.apache.iotdb.session.subscription.consumer.ConsumeResult;
import org.apache.iotdb.session.subscription.consumer.base.AbstractSubscriptionConsumerBuilder;

public class AbstractSubscriptionPushConsumerBuilder
extends AbstractSubscriptionConsumerBuilder {
    protected AckStrategy ackStrategy = AckStrategy.defaultValue();
    protected ConsumeListener consumeListener = message -> ConsumeResult.SUCCESS;
    protected long autoPollIntervalMs = 100L;
    protected long autoPollTimeoutMs = 10000L;

    @Override
    public AbstractSubscriptionPushConsumerBuilder host(String host) {
        super.host(host);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder port(Integer port) {
        super.port(port);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder nodeUrls(List<String> nodeUrls) {
        super.nodeUrls(nodeUrls);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder username(String username) {
        super.username(username);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder password(String password) {
        super.password(password);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder consumerId(String consumerId) {
        super.consumerId(consumerId);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder consumerGroupId(String consumerGroupId) {
        super.consumerGroupId(consumerGroupId);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder heartbeatIntervalMs(long heartbeatIntervalMs) {
        super.heartbeatIntervalMs(heartbeatIntervalMs);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
        super.endpointsSyncIntervalMs(endpointsSyncIntervalMs);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder fileSaveDir(String fileSaveDir) {
        super.fileSaveDir(fileSaveDir);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder fileSaveFsync(boolean fileSaveFsync) {
        super.fileSaveFsync(fileSaveFsync);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder thriftMaxFrameSize(int thriftMaxFrameSize) {
        super.thriftMaxFrameSize(thriftMaxFrameSize);
        return this;
    }

    @Override
    public AbstractSubscriptionPushConsumerBuilder maxPollParallelism(int maxPollParallelism) {
        super.maxPollParallelism(maxPollParallelism);
        return this;
    }

    public AbstractSubscriptionPushConsumerBuilder ackStrategy(AckStrategy ackStrategy) {
        this.ackStrategy = ackStrategy;
        return this;
    }

    public AbstractSubscriptionPushConsumerBuilder consumeListener(ConsumeListener consumeListener) {
        this.consumeListener = consumeListener;
        return this;
    }

    public AbstractSubscriptionPushConsumerBuilder autoPollIntervalMs(long autoPollIntervalMs) {
        this.autoPollIntervalMs = Math.max(autoPollIntervalMs, 1L);
        return this;
    }

    public AbstractSubscriptionPushConsumerBuilder autoPollTimeoutMs(long autoPollTimeoutMs) {
        this.autoPollTimeoutMs = Math.max(autoPollTimeoutMs, 1000L);
        return this;
    }
}

