/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.stream.Streams;
import org.apache.james.transport.mailets.MimeUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class FoldLongLines
extends GenericMailet {
    public static final String MAX_CHARACTERS_PARAMETER_NAME = "maxCharacters";
    public static final String HEADER_SEPARATOR = ": ";
    private static final int DEFAULT_MAX_CHARACTERS = 998;
    private static final String SEPARATOR = "\n";
    private int maxCharacters;

    public void init() throws MessagingException {
        int maxCharacters = this.getInitParameterAsOptional(MAX_CHARACTERS_PARAMETER_NAME).map(Integer::parseInt).orElse(998);
        Preconditions.checkArgument((maxCharacters > 0 ? 1 : 0) != 0, (Object)"maxCharacters must be positive");
        this.maxCharacters = maxCharacters;
    }

    public void service(Mail mail) throws MessagingException {
        Set<String> longHeaders = this.getHeadersExceedingMaxCharacters(mail);
        if (!longHeaders.isEmpty()) {
            List<Header> headers = this.getHeadersWithTheSameNameAsLongHeaders(mail, longHeaders);
            longHeaders.forEach(Throwing.consumer(header -> mail.getMessage().removeHeader(header)));
            headers.forEach(Throwing.consumer(header -> {
                if (this.exceedLineLimit((Header)header)) {
                    mail.getMessage().addHeader(header.getName(), this.fold((Header)header));
                } else {
                    mail.getMessage().addHeader(header.getName(), header.getValue());
                }
            }));
            mail.getMessage().saveChanges();
        }
    }

    private Set<String> getHeadersExceedingMaxCharacters(Mail mail) throws MessagingException {
        return (Set)Streams.of(mail.getMessage().getAllHeaders().asIterator()).filter(this::exceedLineLimit).map(Header::getName).collect(ImmutableSet.toImmutableSet());
    }

    private List<Header> getHeadersWithTheSameNameAsLongHeaders(Mail mail, Set<String> longHeaders) throws MessagingException {
        return Streams.of(mail.getMessage().getAllHeaders().asIterator()).filter(header -> longHeaders.contains(header.getName())).toList();
    }

    private String fold(Header header) {
        int headerNameLength = header.getName().length() + HEADER_SEPARATOR.length();
        return MimeUtil.fold(header.getValue(), headerNameLength, this.maxCharacters);
    }

    private boolean exceedLineLimit(Header header) {
        String fullHeader = header.getName() + HEADER_SEPARATOR + header.getValue();
        return Splitter.on((String)SEPARATOR).splitToStream((CharSequence)fullHeader).anyMatch(line -> line.length() > this.maxCharacters);
    }
}

