/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.filelog;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatchOps;
import org.apache.jena.rdfpatch.changes.RDFChangesN;
import org.apache.jena.rdfpatch.filelog.FilePolicy;
import org.apache.jena.rdfpatch.filelog.OutputMgr;
import org.apache.jena.rdfpatch.filelog.RDFChangesManagedOutput;
import org.apache.jena.rdfpatch.filelog.VocabPatch;
import org.apache.jena.rdfpatch.filelog.rotate.ManagedOutput;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblerFileLog
extends AssemblerBase {
    private static Logger LOG = LoggerFactory.getLogger(AssemblerFileLog.class);

    public Object open(Assembler a, Resource root, Mode mode) {
        DatasetGraph dsgBase;
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabPatch.pDataset)) {
            throw new AssemblerException(root, "No dataset to be logged");
        }
        if (!root.hasProperty(VocabPatch.pLogFile)) {
            throw new AssemblerException(root, "No log file");
        }
        Resource dataset = GraphUtils.getResourceValue((Resource)root, (Property)VocabPatch.pDataset);
        List destLogs = GraphUtils.multiValueAsString((Resource)root, (Property)VocabPatch.pLogFile);
        String logPolicy = GraphUtils.getStringValue((Resource)root, (Property)VocabPatch.pLogPolicy);
        FilePolicy policy = logPolicy == null ? FilePolicy.FIXED : FilePolicy.policy(logPolicy);
        try {
            Dataset dsBase = (Dataset)a.open(dataset);
            dsgBase = dsBase.asDatasetGraph();
        }
        catch (Exception ex) {
            FmtLog.error(((Object)((Object)this)).getClass(), (String)"Failed to build the dataset to adding change logging to: %s", (Object[])new Object[]{dataset});
            throw ex;
        }
        RDFChanges changes = null;
        for (String x : destLogs) {
            RDFChangesManagedOutput sc;
            FmtLog.info((Logger)LOG, (String)"Log file: '%s'", (Object[])new Object[]{x});
            if (x.startsWith("file:")) {
                x = IRILib.IRIToFilename((String)x);
            }
            ManagedOutput output = OutputMgr.create(x, policy);
            String ext = FileUtils.getFilenameExt((String)x);
            boolean binaryPatches = ext.equalsIgnoreCase("trp");
            RDFChangesManagedOutput rDFChangesManagedOutput = sc = binaryPatches ? null : new RDFChangesManagedOutput(output);
            if (sc == null) {
                throw new AssemblerException(root, "Failed to build the output destination: " + x);
            }
            changes = RDFChangesN.multi(changes, sc);
        }
        DatasetGraph dsg = RDFPatchOps.changes(dsgBase, changes);
        Dataset ds = DatasetFactory.wrap((DatasetGraph)dsg);
        return ds;
    }
}

