/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Iterator;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;

public interface Dataset
extends Transactional {
    public Model getDefaultModel();

    public Model getUnionModel();

    public Dataset setDefaultModel(Model var1);

    public Model getNamedModel(String var1);

    public Model getNamedModel(Resource var1);

    public boolean containsNamedModel(String var1);

    public boolean containsNamedModel(Resource var1);

    public Dataset addNamedModel(String var1, Model var2);

    public Dataset addNamedModel(Resource var1, Model var2);

    public Dataset removeNamedModel(String var1);

    public Dataset removeNamedModel(Resource var1);

    public Dataset replaceNamedModel(String var1, Model var2);

    public Dataset replaceNamedModel(Resource var1, Model var2);

    public Iterator<String> listNames();

    public Iterator<Resource> listModelNames();

    public Lock getLock();

    public Context getContext();

    public boolean supportsTransactions();

    public boolean supportsTransactionAbort();

    @Override
    public void begin(ReadWrite var1);

    @Override
    public void commit();

    @Override
    public void abort();

    @Override
    public boolean isInTransaction();

    @Override
    public void end();

    public DatasetGraph asDatasetGraph();

    default public PrefixMapping getPrefixMapping() {
        DatasetGraph dsg = this.asDatasetGraph();
        if (dsg == null) {
            throw new UnsupportedOperationException("Dataset.getPrefixMapping");
        }
        return Prefixes.adapt(dsg.prefixes());
    }

    public void close();

    public boolean isEmpty();
}

