/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.DatasetAssemblerVocab;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class ViewGraphAssembler
extends AssemblerBase
implements Assembler {
    public Model open(Assembler a, Resource root2, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue(root2, DatasetAssemblerVocab.pDataset);
        if (dataset == null) {
            throw new AssemblerException(root2, "Must give a dataset with ja:dataset");
        }
        String graphName = null;
        if (root2.hasProperty(DatasetAssemblerVocab.pNamedGraph)) {
            graphName = GraphUtils.getAsStringValue(root2, DatasetAssemblerVocab.pNamedGraph);
        }
        if (root2.hasProperty(DatasetAssemblerVocab.pGraphName)) {
            graphName = GraphUtils.getAsStringValue(root2, DatasetAssemblerVocab.pGraphName);
        }
        Dataset ds = DatasetFactory.assemble(dataset);
        Model model = graphName == null ? ds.getDefaultModel() : ds.getNamedModel(graphName);
        return model;
    }
}

