/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.apache.jena.fuseki.access.DataAccessCtl;
import org.apache.jena.fuseki.access.DatasetGraphAccessControl;
import org.apache.jena.fuseki.access.GraphFilter;
import org.apache.jena.fuseki.access.GraphFilterTDB1;
import org.apache.jena.fuseki.access.GraphFilterTDB2;
import org.apache.jena.fuseki.access.SecurityContext;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.tdb1.TDB1Factory;
import org.apache.jena.tdb2.DatabaseMgr;

public class SecurityContextView
implements SecurityContext {
    public static SecurityContextView NONE = new SecurityContextView();
    public static SecurityContextView DFT_GRAPH = new SecurityContextView(true);
    private final Collection<Node> graphNames;
    private final boolean matchDefaultGraph;

    private SecurityContextView() {
        this(false);
    }

    private SecurityContextView(boolean matchDefaultGraph) {
        this.matchDefaultGraph = matchDefaultGraph;
        this.graphNames = Collections.emptyList();
    }

    public SecurityContextView(String ... graphNames) {
        this(NodeUtils.convertToSetNodes(graphNames));
    }

    public SecurityContextView(Node ... graphNames) {
        this(Arrays.asList(graphNames));
    }

    public SecurityContextView(Collection<Node> visibleGraphs) {
        ArrayList<Node> x = new ArrayList<Node>();
        x.addAll(visibleGraphs);
        this.matchDefaultGraph = visibleGraphs.stream().anyMatch(Quad::isDefaultGraph);
        if (this.matchDefaultGraph) {
            x.remove(Quad.defaultGraphIRI);
            x.remove(Quad.defaultGraphNodeGenerated);
        }
        this.graphNames = Collections.unmodifiableCollection(x);
    }

    @Override
    public Collection<Node> visibleGraphs() {
        return this.graphNames;
    }

    @Override
    public boolean visableDefaultGraph() {
        return this.matchDefaultGraph;
    }

    @Override
    public QueryExec createQueryExec(Query query2, DatasetGraph dsg) {
        if (SecurityContextView.isAccessControlledTDB(dsg)) {
            QueryExec qExec = QueryExec.dataset(dsg).query(query2).build();
            this.filterTDB(dsg, qExec);
            return qExec;
        }
        DatasetGraph dsgA = DataAccessCtl.filteredDataset(dsg, this);
        return QueryExec.dataset(dsgA).query(query2).build();
    }

    @Override
    public void filterTDB(DatasetGraph dsg, QueryExec qExec) {
        GraphFilter<?> predicate = this.predicate(dsg);
        qExec.getContext().set(predicate.getContextKey(), predicate);
    }

    @Override
    public Predicate<Quad> predicateQuad() {
        return quad -> {
            if (quad.isDefaultGraph()) {
                return this.matchDefaultGraph;
            }
            if (quad.isUnionGraph()) {
                return true;
            }
            return this.graphNames.contains(quad.getGraph());
        };
    }

    protected GraphFilter<?> predicate(DatasetGraph dsg) {
        if (TDB1Factory.isTDB1(dsg = DatasetGraphAccessControl.removeWrapper(dsg))) {
            return GraphFilterTDB1.graphFilter(dsg, this.graphNames, this.matchDefaultGraph);
        }
        if (DatabaseMgr.isTDB2(dsg)) {
            return GraphFilterTDB2.graphFilter(dsg, this.graphNames, this.matchDefaultGraph);
        }
        throw new IllegalArgumentException("Not a TDB1 or TDB2 database: " + dsg.getClass().getSimpleName());
    }

    protected static boolean isAccessControlledTDB(DatasetGraph dsg) {
        DatasetGraph dsgBase = DatasetGraphAccessControl.unwrapOrNull(dsg);
        if (dsgBase == null) {
            return false;
        }
        if (TDB1Factory.isTDB1(dsgBase)) {
            return true;
        }
        return DatabaseMgr.isTDB2(dsgBase);
    }

    public String toString() {
        return "dft:" + this.matchDefaultGraph + " / " + this.graphNames.toString();
    }
}

