/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.access.AccessGeoSPARQL;
import org.apache.jena.geosparql.implementation.access.AccessWGS84;
import org.apache.jena.geosparql.spatial.SpatialIndexItem;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class SpatialIndexFindUtils {
    public static IteratorCloseable<SpatialIndexItem> findIndexItems(DatasetGraph datasetGraph, String srsURI) {
        Graph defaultGraph = datasetGraph.getDefaultGraph();
        IteratorCloseable<SpatialIndexItem> itemsIter = SpatialIndexFindUtils.findIndexItems(defaultGraph, srsURI);
        try {
            Iterator<Node> graphNodeIt = datasetGraph.listGraphNodes();
            Iter namedGraphItemsIt = Iter.iter(graphNodeIt).flatMap(graphNode -> {
                Graph namedGraph = datasetGraph.getGraph((Node)graphNode);
                IteratorCloseable<SpatialIndexItem> graphItems = SpatialIndexFindUtils.findIndexItems(namedGraph, srsURI);
                return graphItems;
            });
            itemsIter = Iter.iter(itemsIter).append(namedGraphItemsIt);
        }
        catch (Throwable t) {
            Iter.close(itemsIter);
            throw new RuntimeException(t);
        }
        return itemsIter;
    }

    public static final IteratorCloseable<SpatialIndexItem> findIndexItems(Graph graph, String srsURI) {
        IteratorCloseable<SpatialIndexItem> result = AccessGeoSPARQL.containsGeoLiterals(graph) ? SpatialIndexFindUtils.findIndexItemsGeoSparql(graph, srsURI) : (AccessWGS84.containsGeoLiteralProperties(graph) ? SpatialIndexFindUtils.findIndexItemsWgs84(graph, srsURI) : Iter.empty());
        return result;
    }

    public static IteratorCloseable<SpatialIndexItem> findIndexItemsGeoSparql(Graph graph, String srsURI) {
        ExtendedIterator<Triple> stmtIter = AccessGeoSPARQL.findSpecificGeoResources(graph);
        Iter<SpatialIndexItem> result = Iter.iter(stmtIter).flatMap(stmt -> {
            Node feature = stmt.getSubject();
            Node geometry = stmt.getObject();
            ExtendedIterator<Triple> serializationIter = AccessGeoSPARQL.findSpecificGeoLiterals(graph, geometry);
            Iterator<SpatialIndexItem> itemIter = Iter.map(serializationIter, triple -> {
                Node geometryNode = triple.getObject();
                GeometryWrapper geometryWrapper = GeometryWrapper.extract(geometryNode);
                SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
                return item;
            });
            return itemIter;
        });
        return result;
    }

    public static IteratorCloseable<SpatialIndexItem> findIndexItemsWgs84(Graph graph, String srsURI) {
        return Iter.iter(AccessWGS84.findGeoLiterals(graph, null)).map(e2 -> {
            Node feature = (Node)e2.getKey();
            GeometryWrapper geometryWrapper = (GeometryWrapper)e2.getValue();
            SpatialIndexItem item = SpatialIndexFindUtils.makeSpatialIndexItem(feature, geometryWrapper, srsURI);
            return item;
        });
    }

    public static SpatialIndexItem makeSpatialIndexItem(Node feature, GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper transformedGeometryWrapper = SpatialIndexFindUtils.unsafeConvert(geometryWrapper, srsURI);
        Envelope envelope = transformedGeometryWrapper.getEnvelope();
        SpatialIndexItem item = new SpatialIndexItem(envelope, feature);
        return item;
    }

    public static GeometryWrapper unsafeConvert(GeometryWrapper geometryWrapper, String srsURI) {
        GeometryWrapper result;
        try {
            result = geometryWrapper.convertSRS(srsURI);
        }
        catch (MismatchedDimensionException | TransformException | FactoryException e2) {
            throw new RuntimeException(e2);
        }
        return result;
    }
}

