/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.iso;

import org.apache.jena.graph.Node;

record IsoMapping(IsoMapping parent, Node node1, Node node2) {
    static final IsoMapping rootMapping = new IsoMapping(null, null, null);

    boolean mapped(Node node) {
        return this.map(node) != null;
    }

    Node map(Node node) {
        IsoMapping mapping = this;
        while (mapping != rootMapping) {
            if (mapping.node1.equals(node)) {
                return mapping.node2;
            }
            mapping = mapping.parent;
        }
        return null;
    }

    boolean reverseMapped(Node node) {
        return this.reverseMap(node) != null;
    }

    Node reverseMap(Node node) {
        IsoMapping mapping = this;
        while (mapping != rootMapping) {
            if (mapping.node2.equals(node)) {
                return mapping.node1;
            }
            mapping = mapping.parent;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        IsoMapping mapping = this;
        while (mapping != rootMapping) {
            sbuff.append("{" + String.valueOf(mapping.node1) + " => " + String.valueOf(mapping.node2) + "}");
            mapping = mapping.parent;
        }
        sbuff.append("{}");
        return sbuff.toString();
    }
}

